/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.pipeline;

import io.github.jidcoo.opto.lcdb.enhancer.base.LeetcodeInvoker;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutor;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutorFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutorProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeInvokerFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.core.pipeline.PipelineRunner;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Require
final class DataStructureDesignScenePipelineRunner
extends PipelineRunner {
    DataStructureDesignScenePipelineRunner() {
    }

    @Require
    List<Object> processOnDataStructureDesignScene(List<String> operations, List<List<Object>> data) {
        AssertUtil.isTrue(!ContainerCheckUtil.isListEmpty(operations), "The operation list cannot be empty.");
        AssertUtil.isTrue(!ContainerCheckUtil.isListEmpty(data), "The data list cannot be empty.");
        AssertUtil.isTrue(operations.size() == data.size(), "The size of lists operation and data is not equal.");
        Class dataStructureKlass = (Class)ReflectUtil.getFieldValue("instance", Object.class, this.getLeetcodeExecutor());
        AssertUtil.nonNull(dataStructureKlass, "The data structure class instance cannot be null.");
        List constructorInvokers = Arrays.stream(dataStructureKlass.getDeclaredConstructors()).map(LeetcodeInvokerFactory::getLeetcodeInvoker).peek(leetcodeInvoker -> ReflectUtil.setFieldValue("matchingFriendly", Boolean.TYPE, Boolean.TRUE, leetcodeInvoker)).collect(Collectors.toList());
        List methodInvokers = Arrays.stream(dataStructureKlass.getDeclaredMethods()).map(LeetcodeInvokerFactory::getLeetcodeInvoker).collect(Collectors.toList());
        Map<String, List<LeetcodeInvoker>> invokersMap = Stream.concat(constructorInvokers.stream(), methodInvokers.stream()).collect(Collectors.groupingBy(LeetcodeInvoker::getInvokerName));
        ArrayList<Object> invokerReturnCollector = new ArrayList<Object>();
        Object dataStructureInstance = null;
        for (int idx = 0; idx < operations.size(); ++idx) {
            String operation = operations.get(idx);
            List<Object> input = data.get(idx);
            List<LeetcodeInvoker> leetcodeInvokers = invokersMap.get(operation);
            AssertUtil.isTrue(!ContainerCheckUtil.isListEmpty(leetcodeInvokers), "Cannot find any candidate leetcode invoker by operation: " + operation);
            LeetcodeExecutor leetcodeExecutor = LeetcodeExecutorFactory.getLeetcodeExecutor(idx == 0 ? this.getEnhancer() : dataStructureInstance, (LeetcodeInvoker[])leetcodeInvokers.stream().toArray(LeetcodeInvoker[]::new));
            Object inputObject = InputParserProcessor.process(this.getInputParser(), leetcodeExecutor, input);
            Object outputObject = LeetcodeExecutorProcessor.process(leetcodeExecutor, inputObject);
            if (idx == 0) {
                dataStructureInstance = outputObject;
                invokerReturnCollector.add(null);
                continue;
            }
            invokerReturnCollector.add(outputObject);
        }
        return invokerReturnCollector;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

