/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.pipeline;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.InputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.base.LeetcodeInvoker;
import io.github.jidcoo.opto.lcdb.enhancer.base.OutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutorFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeInvokerFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.IOFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParser;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.pipeline.LeetcodeJavaDebugEnhancerPipeline;
import io.github.jidcoo.opto.lcdb.enhancer.core.printer.OutputPrinter;
import io.github.jidcoo.opto.lcdb.enhancer.core.printer.OutputPrinterFactory;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;
import java.util.Objects;

public final class LeetcodeJavaDebugEnhancerPipelineProcessor {
    public static void process(LeetcodeJavaDebugEnhancer enhancer) throws Exception, Error {
        AssertUtil.nonNull(enhancer, "The enhancer cannot be null.");
        Object leetcodeExecutor = LeetcodeJavaDebugEnhancerPipelineProcessor.createBootstrapLeetcodeExecutor(enhancer);
        OutputPrinter outputPrinter = OutputPrinterFactory.getOutputPrinter(enhancer);
        InputParser inputParser = InputParserFactory.getInputParser(enhancer);
        try (InputProvider inputProvider = IOFactory.getInputProvider(enhancer);
             OutputConsumer outputConsumer = IOFactory.getOutputConsumer(enhancer);){
            LeetcodeJavaDebugEnhancerPipeline pipeline = new LeetcodeJavaDebugEnhancerPipeline(enhancer, inputProvider, outputConsumer, outputPrinter, leetcodeExecutor, inputParser);
            pipeline.run();
        }
    }

    private static Object createBootstrapLeetcodeExecutor(LeetcodeJavaDebugEnhancer enhancer) {
        if (Objects.nonNull(enhancer.getEnhancementPoint())) {
            return LeetcodeExecutorFactory.getLeetcodeExecutor(enhancer, LeetcodeInvokerFactory.getLeetcodeInvoker(enhancer.getEnhancementPoint()));
        }
        Class<?>[] innerClasses = ReflectUtil.resolveInnerClasses(enhancer.getClass());
        AssertUtil.isTrue(innerClasses.length > 0, "Cannot resolve any inner class from the AT instance.");
        AssertUtil.isTrue(innerClasses.length < 2, "Multiple inner classes were found in AT instance. There can only be one inner class in AT instance.");
        Class<?> bossInnerClassInstance = innerClasses[0];
        if ("Solution".equals(bossInnerClassInstance.getSimpleName())) {
            return LeetcodeExecutorFactory.getLeetcodeExecutor(ReflectUtil.createInstance(bossInnerClassInstance, new Class[]{enhancer.getClass()}, enhancer), new LeetcodeInvoker[0]);
        }
        return LeetcodeExecutorFactory.getLeetcodeExecutor(bossInnerClassInstance, new LeetcodeInvoker[0]);
    }
}

