/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.executor;

import io.github.jidcoo.opto.lcdb.enhancer.base.LeetcodeInvoker;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Objects;

final class ConstructorLeetcodeInvoker
implements LeetcodeInvoker {
    private final Constructor<?> constructor;
    private final Integer id;
    private boolean matchingFriendly;

    ConstructorLeetcodeInvoker(Constructor<?> constructor, Integer id) {
        AssertUtil.nonNull(constructor, "The constructor cannot be null.");
        this.constructor = constructor;
        this.constructor.setAccessible(true);
        this.id = id;
        this.matchingFriendly = false;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public int getParameterCount() {
        int parameterCount = this.constructor.getParameterCount();
        if (parameterCount > 0 && this.matchingFriendly) {
            return parameterCount - 1;
        }
        return parameterCount;
    }

    @Override
    public String getInvokerName() {
        String name = this.constructor.getName();
        if (name.contains("$") && this.matchingFriendly) {
            return name.substring(name.lastIndexOf(36) + 1);
        }
        return name;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        if (parameterTypes.length > 0 && this.matchingFriendly) {
            return (Class[])Arrays.stream(parameterTypes).skip(1L).toArray(Class[]::new);
        }
        return parameterTypes;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = this.constructor.getParameters();
        if (parameters.length > 0 && this.matchingFriendly) {
            return (Parameter[])Arrays.stream(parameters).skip(1L).toArray(Parameter[]::new);
        }
        return parameters;
    }

    @Override
    public Class<?> getReturnType() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public Object invoke(Object object, Object ... args) throws Throwable {
        Object[] initArgsArray;
        if (Modifier.isStatic(this.constructor.getDeclaringClass().getModifiers())) {
            initArgsArray = new Object[args.length];
            System.arraycopy(args, 0, initArgsArray, 0, args.length);
        } else {
            initArgsArray = new Object[args.length + 1];
            if (Objects.nonNull(object)) {
                Class<?> outerClass0 = this.constructor.getParameterTypes()[0];
                AssertUtil.isTrue(outerClass0.isAssignableFrom(object.getClass()), String.format("The object(type is %s) is not the outer class instance of this invoker(real outer class is %s).", object.getClass(), outerClass0));
            }
            initArgsArray[0] = object;
            System.arraycopy(args, 0, initArgsArray, 1, args.length);
        }
        return this.constructor.newInstance(initArgsArray);
    }

    @Override
    public String toGenericString() {
        return this.constructor.toGenericString();
    }
}

