/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.executor;

import io.github.jidcoo.opto.lcdb.enhancer.base.EnhancerException;
import io.github.jidcoo.opto.lcdb.enhancer.base.LeetcodeInvoker;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class LeetcodeExecutor {
    private final Object instance;
    private LeetcodeInvoker executor;
    private final List<LeetcodeInvoker> candidateInvokers;
    private Class<?> invokerResponseType;

    LeetcodeExecutor(Object instance, LeetcodeInvoker executor) {
        this.instance = instance;
        this.executor = executor;
        this.candidateInvokers = new ArrayList<LeetcodeInvoker>();
        if (Objects.nonNull(executor)) {
            this.candidateInvokers.add(executor);
        }
    }

    Object execute(Object input) {
        AssertUtil.nonNull(this.executor, "The leetcode executor cannot be null.");
        try {
            return this.executor.invoke(this.instance, (Object[])input);
        }
        catch (InvocationTargetException exception) {
            throw new EnhancerException(exception.getCause());
        }
        catch (Throwable exception) {
            throw new RuntimeException(exception);
        }
    }

    Object getInstance() {
        return this.instance;
    }

    LeetcodeInvoker getExecutor() {
        return this.executor;
    }

    void setExecutor(LeetcodeInvoker executor) {
        this.executor = executor;
    }

    List<LeetcodeInvoker> getCandidateInvokers() {
        return this.candidateInvokers;
    }
}

