/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.executor;

import io.github.jidcoo.opto.lcdb.enhancer.base.LeetcodeInvoker;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;

final class MethodLeetcodeInvoker
implements LeetcodeInvoker {
    private final Method method;
    private final Integer id;

    MethodLeetcodeInvoker(Method method, Integer id) {
        AssertUtil.nonNull(method, "The method cannot be null.");
        this.method = method;
        this.method.setAccessible(true);
        this.id = id;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public int getParameterCount() {
        return this.method.getParameterCount();
    }

    @Override
    public String getInvokerName() {
        return this.method.getName();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public Parameter[] getParameters() {
        return this.method.getParameters();
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public Object invoke(Object object, Object ... args) throws Throwable {
        if (!Modifier.isStatic(this.method.getModifiers())) {
            Class<?> declaringClass = this.method.getDeclaringClass();
            AssertUtil.isTrue(declaringClass.isAssignableFrom(object.getClass()), String.format("The object(type is %s) is not the owner of this invoker(real owner is %s).", object.getClass(), declaringClass));
        }
        return this.method.invoke(object, args);
    }

    @Override
    public String toGenericString() {
        return this.method.toGenericString();
    }
}

