/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin;

import io.github.jidcoo.opto.lcdb.enhancer.base.InputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MultipleInputProvider
implements InputProvider {
    private final List<InputProvider> providers;
    private int pos = 0;
    private boolean closeFlag = false;

    public MultipleInputProvider(List<InputProvider> inputProviderList) {
        AssertUtil.nonNull(inputProviderList, "The inputProviderList cannot be null.");
        inputProviderList = inputProviderList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        AssertUtil.isTrue(!ContainerCheckUtil.isListEmpty(inputProviderList), "The inputProviderList cannot be empty.");
        this.providers = Collections.unmodifiableList(inputProviderList);
    }

    @Override
    public String provideNextInput() {
        if (this.closeFlag) {
            return null;
        }
        if (this.pos >= this.providers.size()) {
            return null;
        }
        String input = this.providers.get(this.pos).provideNextInput();
        if (this.isEnd(input)) {
            ++this.pos;
            return this.provideNextInput();
        }
        return input;
    }

    @Override
    public boolean isEnd(String input) {
        if (this.closeFlag) {
            return true;
        }
        if (this.pos >= this.providers.size()) {
            return true;
        }
        return this.providers.get(this.pos).isEnd(input);
    }

    @Override
    public void close() throws Exception {
        this.closeFlag = true;
        for (InputProvider provider : this.providers) {
            try {
                provider.close();
            }
            catch (Exception exception) {}
        }
    }
}

