/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin;

import io.github.jidcoo.opto.lcdb.enhancer.base.OutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MultipleOutputConsumer
implements OutputConsumer {
    private final List<OutputConsumer> consumers;
    private boolean closeFlag = false;

    public MultipleOutputConsumer(List<OutputConsumer> outputConsumerList) {
        AssertUtil.nonNull(outputConsumerList, "The outputConsumerList cannot be null.");
        outputConsumerList = outputConsumerList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        AssertUtil.isTrue(!ContainerCheckUtil.isListEmpty(outputConsumerList), "The outputConsumerList cannot be empty.");
        this.consumers = Collections.unmodifiableList(outputConsumerList);
    }

    @Override
    public void consumeNextOutput(String output) {
        if (this.closeFlag) {
            return;
        }
        for (OutputConsumer consumer : this.consumers) {
            if (this.closeFlag) break;
            try {
                consumer.consumeNextOutput(output);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() throws Exception {
        this.closeFlag = true;
        for (OutputConsumer consumer : this.consumers) {
            try {
                consumer.close();
            }
            catch (Exception exception) {}
        }
    }
}

