/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.parser;

import io.github.jidcoo.opto.lcdb.enhancer.base.BaseParameterAcceptStrategy;
import io.github.jidcoo.opto.lcdb.enhancer.base.Order;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.ParameterAcceptResult;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.ParameterAcceptStrategyTracer;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.BeanUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;

final class ParameterAcceptor
extends BaseParameterAcceptStrategy<Object> {
    private Map<Class<?>, Set<BaseParameterAcceptStrategy<?>>> builtinAcceptStrategyMap;
    private final Comparator<Order> strategyComparator = Comparator.comparingInt(Order::getOrder).reversed();
    private static final String BUILT_IN_PARAMETER_ACCEPTANCE_STRATEGY_PACKAGE = "io.github.jidcoo.opto.lcdb.enhancer.core.parser.builtin";

    ParameterAcceptor() {
        this.builtinAcceptStrategyMap = new HashMap();
        List strategies = BeanUtil.collectBeans(BaseParameterAcceptStrategy.class, BUILT_IN_PARAMETER_ACCEPTANCE_STRATEGY_PACKAGE, type -> type.isAnnotationPresent(Require.class) && ReflectUtil.isExtendsClass(type, BaseParameterAcceptStrategy.class) && !Modifier.isAbstract(type.getModifiers()), beanType -> (BaseParameterAcceptStrategy)ReflectUtil.createInstance(beanType)).stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!ContainerCheckUtil.isListEmpty(strategies)) {
            for (BaseParameterAcceptStrategy strategy : strategies) {
                this.addParameterAcceptStrategy(strategy.getAcceptableType(), strategy, this.builtinAcceptStrategyMap);
            }
        }
    }

    private void addParameterAcceptStrategy(Class<?> type, BaseParameterAcceptStrategy<?> strategy, Map<Class<?>, Set<BaseParameterAcceptStrategy<?>>> strategyMap) {
        AssertUtil.nonNull(strategy, "The parameter acceptance strategy cannot be null.");
        AssertUtil.nonNull(type, "The type of the " + strategy + " cannot be null.");
        Set strategySet = strategyMap.computeIfAbsent(type, key -> new TreeSet<Order>(this.strategyComparator));
        strategySet.add(strategy);
    }

    public ParameterAcceptResult accept(Parameter invokerParameterType, Object object) {
        Stack<ParameterAcceptStrategyTracer> tracerStack = new Stack<ParameterAcceptStrategyTracer>();
        try {
            Set strategySet = this.findStrategySet(invokerParameterType.getType(), this.builtinAcceptStrategyMap);
            for (BaseParameterAcceptStrategy acceptStrategy : strategySet) {
                try {
                    return ParameterAcceptResult.accept(acceptStrategy.accept((Object)invokerParameterType, object, this.builtinAcceptStrategyMap));
                }
                catch (Throwable e) {
                    tracerStack.push(new ParameterAcceptStrategyTracer(acceptStrategy.getClass().getName(), e));
                }
            }
        }
        catch (Throwable throwable) {
            tracerStack.push(new ParameterAcceptStrategyTracer(null, throwable));
        }
        return ParameterAcceptResult.reject(object, tracerStack);
    }

    @Override
    protected Object acceptParameter(Object object, Parameter type, Map<Class<?>, Set<BaseParameterAcceptStrategy<?>>> strategiesMap) throws Throwable {
        throw new RuntimeException("Unsupported!");
    }

    @Override
    public int getOrder() {
        throw new RuntimeException("Unsupported!");
    }

    @Override
    public Class<?> getAcceptableType() {
        throw new RuntimeException("Unsupported!");
    }
}

