/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.pipeline;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.InputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.base.LeetcodeInvoker;
import io.github.jidcoo.opto.lcdb.enhancer.base.Order;
import io.github.jidcoo.opto.lcdb.enhancer.base.OutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutor;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutorFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeExecutorProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeInvokerFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.parser.InputParserProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.core.pipeline.PipelineRunner;
import io.github.jidcoo.opto.lcdb.enhancer.core.printer.OutputPrinterProcessor;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.BeanUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class LeetcodeJavaDebugEnhancerPipeline
extends PipelineRunner {
    private final LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer;
    private final InputProvider inputProvider;
    private final OutputConsumer outputConsumer;
    private final Object outputPrinter;
    private final Object leetcodeExecutor;
    private final Object inputParser;
    private final Map<Integer, PipelineRunner> pipelineRunnerMap;
    private final List<LeetcodeInvoker> pipelineRunnerInvokers;
    private static final String BUILT_IN_PIPELINE_RUNNER_PACKAGE = "io.github.jidcoo.opto.lcdb.enhancer.core.pipeline";

    LeetcodeJavaDebugEnhancerPipeline(LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer, InputProvider inputProvider, OutputConsumer outputConsumer, Object outputPrinter, Object leetcodeExecutor, Object inputParser) {
        AssertUtil.nonNull(leetcodeJavaDebugEnhancer, "The enhancer cannot be null.");
        this.leetcodeJavaDebugEnhancer = leetcodeJavaDebugEnhancer;
        AssertUtil.nonNull(inputProvider, "The input provider cannot be null.");
        this.inputProvider = inputProvider;
        AssertUtil.nonNull(outputConsumer, "The output consumer cannot be null.");
        this.outputConsumer = outputConsumer;
        AssertUtil.nonNull(outputPrinter, "The output printer cannot be null.");
        this.outputPrinter = outputPrinter;
        AssertUtil.nonNull(leetcodeExecutor, "The leetcode executor cannot be null.");
        this.leetcodeExecutor = leetcodeExecutor;
        AssertUtil.nonNull(inputParser, "The input parser cannot be null.");
        this.inputParser = inputParser;
        this.pipelineRunnerMap = new HashMap<Integer, PipelineRunner>();
        this.pipelineRunnerInvokers = new ArrayList<LeetcodeInvoker>();
        List builtinPipelineRunners = BeanUtil.collectBeans(PipelineRunner.class, BUILT_IN_PIPELINE_RUNNER_PACKAGE, klass -> klass.isAnnotationPresent(Require.class) && ReflectUtil.isExtendsClass(klass, PipelineRunner.class) && !Modifier.isAbstract(klass.getModifiers()), klass -> (PipelineRunner)ReflectUtil.createInstance(klass)).stream().filter(Objects::nonNull).sorted(Comparator.comparingInt(Order::getOrder).reversed()).collect(Collectors.toList());
        for (PipelineRunner builtinPipelineRunner : builtinPipelineRunners) {
            for (Method candidateMethod : builtinPipelineRunner.getClass().getDeclaredMethods()) {
                if (!candidateMethod.isAnnotationPresent(Require.class)) continue;
                LeetcodeInvoker leetcodeInvoker = LeetcodeInvokerFactory.getLeetcodeInvoker(candidateMethod);
                this.pipelineRunnerInvokers.add(leetcodeInvoker);
                this.pipelineRunnerMap.put(leetcodeInvoker.getId(), builtinPipelineRunner);
            }
        }
    }

    void run() {
        String input;
        while (!this.inputProvider.isEnd(input = this.inputProvider.provideNextInput())) {
            Object bossLeetcodeExecutor = this.leetcodeExecutor;
            bossLeetcodeExecutor = this.doEnhanceBeforeInputParseProcess(bossLeetcodeExecutor);
            Object inputObject = InputParserProcessor.process(this.inputParser, bossLeetcodeExecutor, input);
            bossLeetcodeExecutor = this.doEnhanceAfterInputParseProcess(bossLeetcodeExecutor);
            Object outputObject = LeetcodeExecutorProcessor.process(bossLeetcodeExecutor, inputObject);
            String output = OutputPrinterProcessor.process(this.outputPrinter, bossLeetcodeExecutor, outputObject);
            this.outputConsumer.consumeNextOutput(output);
        }
    }

    private Object doEnhanceBeforeInputParseProcess(Object bossLeetcodeExecutor) {
        List candidateInvokers = ReflectUtil.getFieldValue("candidateInvokers", List.class, bossLeetcodeExecutor);
        if (Objects.nonNull(candidateInvokers)) {
            candidateInvokers.addAll(this.pipelineRunnerInvokers);
        }
        return bossLeetcodeExecutor;
    }

    private Object doEnhanceAfterInputParseProcess(Object bossLeetcodeExecutor) {
        LeetcodeInvoker leetcodeInvoker = ReflectUtil.getFieldValue("executor", LeetcodeInvoker.class, bossLeetcodeExecutor);
        if (!this.pipelineRunnerMap.containsKey(leetcodeInvoker.getId())) {
            return bossLeetcodeExecutor;
        }
        PipelineRunner pipelineRunner = this.pipelineRunnerMap.get(leetcodeInvoker.getId());
        this.setupPipelineRunner(pipelineRunner);
        LeetcodeExecutor finalLeetcodeExecutor = LeetcodeExecutorFactory.getLeetcodeExecutor(pipelineRunner, leetcodeInvoker);
        ReflectUtil.setFieldValue("executor", LeetcodeInvoker.class, null, bossLeetcodeExecutor);
        return finalLeetcodeExecutor;
    }

    private void setupPipelineRunner(PipelineRunner pipelineRunner) {
        ReflectUtil.setFieldValue("baseRunner", PipelineRunner.class, this, pipelineRunner);
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    protected LeetcodeJavaDebugEnhancer getEnhancer() {
        return this.leetcodeJavaDebugEnhancer;
    }

    @Override
    protected InputProvider getInputProvider() {
        return this.inputProvider;
    }

    @Override
    protected OutputConsumer getOutputConsumer() {
        return this.outputConsumer;
    }

    @Override
    protected Object getOutputPrinter() {
        return this.outputPrinter;
    }

    @Override
    protected Object getLeetcodeExecutor() {
        return this.leetcodeExecutor;
    }

    @Override
    protected Object getInputParser() {
        return this.inputParser;
    }
}

