/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.proxy;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.BasePrintingStrategy;
import io.github.jidcoo.opto.lcdb.enhancer.base.EnhancerException;
import io.github.jidcoo.opto.lcdb.enhancer.base.InputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.base.LeetcodeInvoker;
import io.github.jidcoo.opto.lcdb.enhancer.base.OutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.core.executor.LeetcodeInvokerFactory;
import io.github.jidcoo.opto.lcdb.enhancer.core.proxy.ProxyPointInterceptorManager;
import io.github.jidcoo.opto.lcdb.enhancer.core.proxy.ProxyPointParameterView;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class DebugEnhancerProxy
extends LeetcodeJavaDebugEnhancer {
    private static final Class<?>[] DEFAULT_NO_PARAM_TYPE = new Class[0];
    private final Map<String, ProxyPoint> PROXY_POINTS_MAP = Arrays.asList(new ProxyPoint("getEnhancementPoint", DEFAULT_NO_PARAM_TYPE), new ProxyPoint("getInputProvider", DEFAULT_NO_PARAM_TYPE), new ProxyPoint("getOutputConsumer", DEFAULT_NO_PARAM_TYPE), new ProxyPoint("getOutputPrintStrategies", DEFAULT_NO_PARAM_TYPE), new ProxyPoint("getEnhancerLogLevel", DEFAULT_NO_PARAM_TYPE)).stream().collect(Collectors.toMap(ProxyPoint::getPointName, proxyPoint -> proxyPoint));
    private Map<String, LeetcodeInvoker> proxyPointInstancesMap;
    private ProxyPointInterceptorManager proxyPointInterceptorManager;
    private final LeetcodeJavaDebugEnhancer target;

    public DebugEnhancerProxy(LeetcodeJavaDebugEnhancer target) {
        AssertUtil.nonNull(target, "The LeetcodeJavaDebugEnhancer target cannot be null.");
        Class<?> targetClass = target.getClass();
        this.proxyPointInstancesMap = new HashMap<String, LeetcodeInvoker>();
        this.proxyPointInterceptorManager = new ProxyPointInterceptorManager(this.PROXY_POINTS_MAP.keySet());
        this.PROXY_POINTS_MAP.forEach((proxyPointName, proxyPoint) -> this.proxyPointInstancesMap.put((String)proxyPointName, proxyPoint.findPoint(targetClass)));
        this.target = target;
    }

    private <RETURN> RETURN proxyPointInvoke(String pointName, Class<RETURN> returnType, Object ... args) {
        ProxyPoint proxyPoint = this.PROXY_POINTS_MAP.getOrDefault(pointName, null);
        AssertUtil.nonNull(proxyPoint, "Cannot found the proxy point: " + pointName);
        LeetcodeInvoker proxyPointInvoker = this.proxyPointInstancesMap.getOrDefault(pointName, null);
        AssertUtil.nonNull(proxyPointInvoker, "Cannot found the proxy point invoker: " + pointName);
        ProxyPointParameterView parameterView = new ProxyPointParameterView(proxyPoint.getParamTypes(), args);
        try {
            this.proxyPointInterceptorManager.doInterceptOnBefore(this, pointName, parameterView);
            Object result = proxyPointInvoker.invoke(this.target, args);
            return returnType.cast(this.proxyPointInterceptorManager.doInterceptOnAfter(this, pointName, result));
        }
        catch (Throwable throwable) {
            throw new EnhancerException("proxy invoke error: " + throwable.getMessage(), throwable);
        }
    }

    public LeetcodeJavaDebugEnhancer getTarget() {
        return this.target;
    }

    public static LeetcodeJavaDebugEnhancer awareSource(LeetcodeJavaDebugEnhancer enhancer) {
        if (Objects.isNull(enhancer)) {
            return null;
        }
        if (enhancer instanceof DebugEnhancerProxy) {
            return ((DebugEnhancerProxy)enhancer).getTarget();
        }
        return enhancer;
    }

    @Override
    public Method getEnhancementPoint() {
        return this.proxyPointInvoke("getEnhancementPoint", Method.class, new Object[0]);
    }

    @Override
    public InputProvider getInputProvider() {
        return this.proxyPointInvoke("getInputProvider", InputProvider.class, new Object[0]);
    }

    @Override
    public OutputConsumer getOutputConsumer() {
        return this.proxyPointInvoke("getOutputConsumer", OutputConsumer.class, new Object[0]);
    }

    @Override
    public List<BasePrintingStrategy<?>> getOutputPrintStrategies() {
        return this.proxyPointInvoke("getOutputPrintStrategies", List.class, new Object[0]);
    }

    @Override
    public Level getEnhancerLogLevel() {
        return this.proxyPointInvoke("getEnhancerLogLevel", Level.class, new Object[0]);
    }

    private final class ProxyPoint {
        private final String pointName;
        private final Class<?>[] paramTypes;

        ProxyPoint(String pointName, Class<?>[] paramTypes) {
            AssertUtil.isTrue(!StringUtil.isBlank(pointName), "The proxy point name cannot be blank.");
            AssertUtil.nonNull(paramTypes, "The proxy point param types cannot be null.");
            this.pointName = pointName;
            this.paramTypes = paramTypes;
        }

        String getPointName() {
            return this.pointName;
        }

        Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        LeetcodeInvoker findPoint(Class<?> klass) {
            AssertUtil.nonNull(klass, "The class cannot be null.");
            try {
                return LeetcodeInvokerFactory.getLeetcodeInvoker(ReflectUtil.getMethod(klass, this.pointName, this.paramTypes));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EnhancerException("Cannot found proxy point in class " + klass.getSimpleName() + ", point name is " + this.pointName + ", param type is " + Arrays.toString(this.paramTypes) + ".");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxyPoint that = (ProxyPoint)o;
            return Objects.equals(this.pointName, that.pointName) && Arrays.equals(this.paramTypes, that.paramTypes);
        }

        public int hashCode() {
            int result = Objects.hash(this.pointName);
            result = 31 * result + Arrays.hashCode(this.paramTypes);
            return result;
        }
    }
}

