/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.proxy;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.Order;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.core.proxy.ProxyPointInterceptor;
import io.github.jidcoo.opto.lcdb.enhancer.core.proxy.ProxyPointParameterView;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.BeanUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.EnhancerLogUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ReflectUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class ProxyPointInterceptorManager {
    private final Map<String, List<ProxyPointInterceptor>> proxyPointInterceptorsMap;
    private static final String PROXY_POINT_INTERCEPTOR_SCANNER_BASE_PACKAGE = "io.github.jidcoo.opto.lcdb.enhancer.func";

    ProxyPointInterceptorManager(Set<String> allowedProxyPointsSet) {
        AssertUtil.nonNull(allowedProxyPointsSet, "The allowed proxy points set cannot be null.");
        this.proxyPointInterceptorsMap = BeanUtil.collectBeans(ProxyPointInterceptor.class, PROXY_POINT_INTERCEPTOR_SCANNER_BASE_PACKAGE, type -> {
            boolean baseValidResult;
            boolean bl = baseValidResult = type.isAnnotationPresent(Require.class) && ReflectUtil.isImplementInterface(type, ProxyPointInterceptor.class) && !Modifier.isAbstract(type.getModifiers());
            if (!baseValidResult) {
                return false;
            }
            Require requireAnnotation = type.getAnnotation(Require.class);
            return requireAnnotation.types().length > 0 && ProxyPointInterceptor.class.equals(requireAnnotation.types()[0]);
        }, beanType -> {
            ProxyPointInterceptor interceptor = (ProxyPointInterceptor)ReflectUtil.createInstance(beanType);
            if (allowedProxyPointsSet.contains(interceptor.interceptPoint())) {
                return interceptor;
            }
            EnhancerLogUtil.logW("Invalid interceptor, detected a disallowed intercept-proxy-point: " + interceptor.interceptPoint(), new Object[0]);
            return null;
        }).stream().filter(Objects::nonNull).collect(Collectors.groupingBy(ProxyPointInterceptor::interceptPoint, Collectors.collectingAndThen(Collectors.toList(), list -> {
            list.sort(Comparator.comparingInt(Order::getOrder).reversed());
            return list;
        })));
    }

    public void doInterceptOnBefore(LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer, String pointName, ProxyPointParameterView parameterView) {
        AssertUtil.isTrue(!StringUtil.isBlank(pointName), "The proxy point name cannot be blank.");
        AssertUtil.nonNull(parameterView, "The proxy point parameter view cannot be null.");
        List interceptors = this.proxyPointInterceptorsMap.getOrDefault(pointName, null);
        if (ContainerCheckUtil.isListEmpty(interceptors)) {
            return;
        }
        for (ProxyPointInterceptor interceptor : interceptors) {
            interceptor.onBefore(leetcodeJavaDebugEnhancer, parameterView);
        }
    }

    public Object doInterceptOnAfter(LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer, String pointName, Object o) {
        AssertUtil.isTrue(!StringUtil.isBlank(pointName), "The proxy point name cannot be blank.");
        List interceptors = this.proxyPointInterceptorsMap.getOrDefault(pointName, null);
        if (!ContainerCheckUtil.isListEmpty(interceptors)) {
            for (ProxyPointInterceptor interceptor : interceptors) {
                o = interceptor.onAfter(leetcodeJavaDebugEnhancer, o);
            }
        }
        return o;
    }
}

