/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.core.proxy;

import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import java.util.Objects;

public final class ProxyPointParameterView {
    private final Class<?>[] types;
    private final Object[] params;
    private final int size;

    public ProxyPointParameterView(Class<?>[] types, Object[] params) {
        AssertUtil.nonNull(types, "The param types cannot be null.");
        AssertUtil.nonNull(types, "The params cannot be null.");
        AssertUtil.isTrue(types.length == params.length, "The length of param types does not match the length of the params.");
        this.types = types;
        this.params = params;
        this.size = types.length;
    }

    public int getSize() {
        return this.size;
    }

    public Class<?> getParameterType(int pos) {
        AssertUtil.isTrue(pos >= 0 && pos < this.size, "Illegal parameter position.");
        return this.types[pos];
    }

    public Object getParameter(int pos) {
        AssertUtil.isTrue(pos >= 0 && pos < this.size, "Illegal parameter position.");
        return this.params[pos];
    }

    public void setParameter(int pos, Object value) {
        AssertUtil.isTrue(pos >= 0 && pos < this.size, "Illegal parameter position.");
        if (Objects.nonNull(value)) {
            AssertUtil.isTrue(Objects.equals(value.getClass(), this.types[pos]), "Illegal parameter value type.");
        }
        this.params[pos] = value;
    }
}

