/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.func.require.io;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.EnhancerException;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.base.Requires;
import io.github.jidcoo.opto.lcdb.enhancer.core.proxy.DebugEnhancerProxy;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.EnhancerLogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

abstract class AbsIORequireSupporter<IO_SOURCE> {
    private final Map<Class<? extends IO_SOURCE>, Function<String, IO_SOURCE>> ACCEPTABLE_IO_SOURCE_TYPES = new ConcurrentHashMap<Class<? extends IO_SOURCE>, Function<String, IO_SOURCE>>();

    AbsIORequireSupporter() {
    }

    protected final void enableIOSourceType(Class<? extends IO_SOURCE> type, Function<String, IO_SOURCE> generator) {
        AssertUtil.nonNull(type, "The io source type cannot be null.");
        AssertUtil.nonNull(type, "The io source generator cannot be null.");
        this.ACCEPTABLE_IO_SOURCE_TYPES.put(type, generator);
    }

    protected final Function<String, IO_SOURCE> disableIOSourceType(Class<? extends IO_SOURCE> type) {
        AssertUtil.nonNull(type, "The io source type cannot be null.");
        return this.ACCEPTABLE_IO_SOURCE_TYPES.remove(type);
    }

    protected IO_SOURCE generateIOSource(String source, Class<? extends IO_SOURCE> type) {
        AssertUtil.nonNull(type, "The io source type cannot be null.");
        if (!this.ACCEPTABLE_IO_SOURCE_TYPES.containsKey(type)) {
            throw new EnhancerException("Unsupported io source type in IO-Require-Annotation interceptor: " + type.getSimpleName());
        }
        Function<String, IO_SOURCE> generator = this.ACCEPTABLE_IO_SOURCE_TYPES.get(type);
        AssertUtil.nonNull(generator, "The io source generator in type " + type.getSimpleName() + " cannot be null.");
        return generator.apply(source);
    }

    protected List<Require> awareAcceptableIOSourceRequire(LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer) {
        List<Require> requireList;
        LeetcodeJavaDebugEnhancer source = DebugEnhancerProxy.awareSource(leetcodeJavaDebugEnhancer);
        AssertUtil.nonNull(source, "The leetcodeJavaDebugEnhancer cannot be null.");
        Class<?> sourceKlass = source.getClass();
        Requires requiresAnnotation = sourceKlass.getAnnotation(Requires.class);
        Require requireAnnotation = sourceKlass.getAnnotation(Require.class);
        if (Objects.nonNull(requiresAnnotation)) {
            requireList = Arrays.asList(requiresAnnotation.value());
        } else if (Objects.nonNull(requireAnnotation)) {
            requireList = Collections.singletonList(requireAnnotation);
        } else {
            return null;
        }
        requireList = requireList.stream().filter(require -> {
            Object[] types = require.types();
            if (types.length == 0) {
                return false;
            }
            for (Class<?> clazz : types) {
                if (this.ACCEPTABLE_IO_SOURCE_TYPES.containsKey(clazz)) continue;
                EnhancerLogUtil.logW("Unaccepted io source type in IO-Require-Annotation(types are %s, values are %s): %s", Arrays.toString(types), Arrays.toString(require.values()), clazz.getSimpleName());
                return false;
            }
            return true;
        }).filter(require -> {
            int typesLength = require.types().length;
            int valuesLength = require.values().length;
            if (typesLength > 1 && typesLength > valuesLength) {
                EnhancerLogUtil.logW("Invalid types-length(%d) and values-length(%d) in IO-Require-Annotation(types are %s, values are %s): Only supports single type and multi value or types and values with the same length.", typesLength, valuesLength, Arrays.toString(require.types()), Arrays.toString(require.values()));
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        return requireList;
    }

    protected final List<IO_SOURCE> awareIOSources(LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer) {
        List<Require> requireList = this.awareAcceptableIOSourceRequire(leetcodeJavaDebugEnhancer);
        ArrayList ioSourceList = new ArrayList();
        if (!ContainerCheckUtil.isListEmpty(requireList)) {
            for (Require require : requireList) {
                List curSources;
                Class[] types = require.types();
                String[] values = require.values();
                if (types.length == 1) {
                    Class<?> ioSourceType = types[0];
                    curSources = Arrays.stream(values).map(source -> this.generateIOSource((String)source, (Class<? extends IO_SOURCE>)ioSourceType)).filter(Objects::nonNull).collect(Collectors.toList());
                } else {
                    curSources = IntStream.range(0, types.length).boxed().map(pos -> {
                        Class ioSourceType = types[pos];
                        String source = values[pos];
                        return this.generateIOSource(source, ioSourceType);
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                }
                if (ContainerCheckUtil.isListEmpty(curSources)) continue;
                ioSourceList.addAll(curSources);
            }
        }
        return ioSourceList;
    }
}

