/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.func.require.io;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.EnhancerException;
import io.github.jidcoo.opto.lcdb.enhancer.base.InputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin.ConsoleInputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin.FileInputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin.MultipleInputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin.StringInputProvider;
import io.github.jidcoo.opto.lcdb.enhancer.core.proxy.ProxyPointInterceptor;
import io.github.jidcoo.opto.lcdb.enhancer.func.require.io.AbsIORequireSupporter;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Objects;

@Require(types={ProxyPointInterceptor.class})
final class InputProviderRequireInterceptor
extends AbsIORequireSupporter<InputProvider>
implements ProxyPointInterceptor<InputProvider> {
    InputProviderRequireInterceptor() {
        this.enableIOSourceType(ConsoleInputProvider.class, source -> new ConsoleInputProvider());
        this.enableIOSourceType(StringInputProvider.class, source -> new StringInputProvider((String)source));
        this.enableIOSourceType(FileInputProvider.class, source -> {
            AssertUtil.isTrue(!StringUtil.isBlank(source), "The file path string value cannot be blank in FileInputProvider Require type.");
            try {
                return new FileInputProvider((String)source);
            }
            catch (FileNotFoundException e) {
                throw new EnhancerException("The file cannot found in FileInputProvider Require: " + source, e);
            }
        });
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String interceptPoint() {
        return "getInputProvider";
    }

    @Override
    public InputProvider onAfter(LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer, InputProvider inputProvider) {
        List<InputProvider> inputProviderList = this.awareIOSources(leetcodeJavaDebugEnhancer);
        if (!ContainerCheckUtil.isListEmpty(inputProviderList)) {
            if (Objects.nonNull(inputProvider)) {
                inputProviderList.add(inputProvider);
            }
            inputProvider = new MultipleInputProvider(inputProviderList);
        }
        return inputProvider;
    }
}

