/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.func.require.io;

import io.github.jidcoo.opto.lcdb.enhancer.LeetcodeJavaDebugEnhancer;
import io.github.jidcoo.opto.lcdb.enhancer.base.EnhancerException;
import io.github.jidcoo.opto.lcdb.enhancer.base.OutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.base.Require;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin.ConsoleOutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin.FileOutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.core.io.builtin.MultipleOutputConsumer;
import io.github.jidcoo.opto.lcdb.enhancer.core.proxy.ProxyPointInterceptor;
import io.github.jidcoo.opto.lcdb.enhancer.func.require.io.AbsIORequireSupporter;
import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.ContainerCheckUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Objects;

@Require(types={ProxyPointInterceptor.class})
final class OutputConsumerRequireInterceptor
extends AbsIORequireSupporter<OutputConsumer>
implements ProxyPointInterceptor<OutputConsumer> {
    OutputConsumerRequireInterceptor() {
        this.enableIOSourceType(ConsoleOutputConsumer.class, source -> new ConsoleOutputConsumer());
        this.enableIOSourceType(FileOutputConsumer.class, source -> {
            AssertUtil.isTrue(!StringUtil.isBlank(source), "The file path string value cannot be blank in FileOutputConsumer Require type.");
            try {
                return new FileOutputConsumer((String)source);
            }
            catch (FileNotFoundException e) {
                throw new EnhancerException("The file cannot found in FileOutputConsumer Require: " + source, e);
            }
        });
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public String interceptPoint() {
        return "getOutputConsumer";
    }

    @Override
    public OutputConsumer onAfter(LeetcodeJavaDebugEnhancer leetcodeJavaDebugEnhancer, OutputConsumer outputConsumer) {
        List<OutputConsumer> outputConsumerList = this.awareIOSources(leetcodeJavaDebugEnhancer);
        if (!ContainerCheckUtil.isListEmpty(outputConsumerList)) {
            if (Objects.nonNull(outputConsumer)) {
                outputConsumerList.add(outputConsumer);
            }
            outputConsumer = new MultipleOutputConsumer(outputConsumerList);
        }
        return outputConsumer;
    }
}

