/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.utils;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageUtil {
    public static List<Class<?>> getClassesByPackage(String packageName) {
        ArrayList classes = new ArrayList();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    PackageUtil.findClassesByPackagePath(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (name.charAt(0) == '/') {
                        name = name.substring(1);
                    }
                    if (!name.startsWith(packageDirName)) continue;
                    int idx = name.lastIndexOf(47);
                    if (idx != -1) {
                        packageName = name.substring(0, idx).replace('/', '.');
                    }
                    if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                    String className = name.substring(packageName.length() + 1, name.length() - 6);
                    classes.add(Class.forName(packageName + '.' + className));
                }
            }
        }
        catch (Error | Exception e) {
            throw new RuntimeException(e);
        }
        return classes;
    }

    public static void findClassesByPackagePath(String packageName, String packagePath, boolean recursive, List<Class<?>> classes) {
        File[] dirFiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file2 : dirFiles = dir.listFiles(file -> recursive && file.isDirectory() || file.getName().endsWith(".class"))) {
            if (file2.isDirectory()) {
                PackageUtil.findClassesByPackagePath(packageName + "." + file2.getName(), file2.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file2.getName().substring(0, file2.getName().length() - 6);
            try {
                classes.add(Class.forName(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

