/*
 * Decompiled with CFR 0.152.
 */
package io.github.jidcoo.opto.lcdb.enhancer.utils;

import io.github.jidcoo.opto.lcdb.enhancer.utils.AssertUtil;
import io.github.jidcoo.opto.lcdb.enhancer.utils.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

public class ReflectUtil {
    public static <T> T createInstance(Class<T> clazz, Class<?>[] constructorParameterTypes, Object ... constructorParameters) {
        AssertUtil.nonNull(clazz, "The class cannot be null.");
        if (Objects.isNull(constructorParameterTypes)) {
            constructorParameterTypes = new Class[]{};
        }
        try {
            Constructor<T> declaredConstructor = clazz.getDeclaredConstructor(constructorParameterTypes);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(constructorParameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstance(Class<T> clazz) {
        return ReflectUtil.createInstance(clazz, null, new Object[0]);
    }

    public static Class<?>[] resolveInnerClasses(Class<?> clazz) {
        AssertUtil.nonNull(clazz, "The clazz cannot be null.");
        return clazz.getDeclaredClasses();
    }

    public static boolean isImplementInterface(Class<?> clazz, Class<?> interfaceClass) {
        AssertUtil.nonNull(clazz, "The class cannot be null.");
        AssertUtil.nonNull(interfaceClass, "The interface cannot be null.");
        return Arrays.stream(clazz.getInterfaces()).anyMatch(clz -> interfaceClass == clz);
    }

    public static boolean isExtendsClass(Class<?> clazz, Class<?> superClass) {
        AssertUtil.nonNull(clazz, "The class cannot be null.");
        AssertUtil.nonNull(superClass, "The super class cannot be null.");
        return superClass.isAssignableFrom(clazz);
    }

    public static Field getField(String fieldName, Class fieldType, Object obj) {
        AssertUtil.isTrue(!StringUtil.isBlank(fieldName), "The fieldName cannot be blank.");
        AssertUtil.nonNull(fieldType, "The fieldType cannot be null.");
        AssertUtil.nonNull(obj, "The obj cannot be null.");
        Field field = null;
        Class<?> classFinder = obj.getClass();
        while (Objects.isNull(field) && Objects.nonNull(classFinder)) {
            try {
                field = classFinder.getDeclaredField(fieldName);
            }
            catch (Error | Exception e) {
                classFinder = classFinder.getSuperclass();
            }
        }
        AssertUtil.nonNull(field, "Cannot match any field by field name [" + fieldName + "] in object: " + obj);
        AssertUtil.isTrue(Objects.equals(field.getType(), fieldType), "The type of the field " + fieldName + " in object " + obj + " is " + field.getType().getSimpleName() + ", not " + fieldType.getSimpleName() + ".");
        return field;
    }

    public static <T> T getFieldValue(String fieldName, Class<? extends T> fieldType, Object obj) {
        Field field = ReflectUtil.getField(fieldName, fieldType, obj);
        try {
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setFieldValue(String fieldName, Class<? extends T> fieldType, Object value, Object obj) {
        Field field = ReflectUtil.getField(fieldName, fieldType, obj);
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(Class<?> target, String methodName, Class<?> ... parameterTypes) {
        AssertUtil.nonNull(target, "The target class cannot be null.");
        AssertUtil.isTrue(!StringUtil.isBlank(methodName), "The method name cannot be blank.");
        Method method = null;
        Class<?> classFinder = target;
        while (Objects.isNull(method) && Objects.nonNull(classFinder)) {
            try {
                method = classFinder.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Error | Exception e) {
                classFinder = classFinder.getSuperclass();
            }
        }
        AssertUtil.nonNull(method, "Cannot match any method by method name [" + methodName + "] and parameters " + Arrays.toString(parameterTypes) + " in class: " + target.getName());
        return method;
    }
}

