/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.account.request.AccountDataRequest;
import com.abfinance.api.client.restApi.ABFinanceApiAccountRestClient;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;

public class ABFinanceApiAccountRestClientImpl
implements ABFinanceApiAccountRestClient {
    private final ABFinanceApiService apiService;

    public ABFinanceApiAccountRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public Object getWalletBalance(AccountDataRequest walletBalanceRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getWalletBalance(walletBalanceRequest.getAccountType() == null ? null : walletBalanceRequest.getAccountType().getAccountTypeValue(), walletBalanceRequest.getCoins()));
    }

    @Override
    public Object getAccountFreeRate(AccountDataRequest getFeeRateRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAccountFreeRate(getFeeRateRequest.getCategory().getCategoryTypeId(), getFeeRateRequest.getSymbol(), getFeeRateRequest.getBaseCoin()));
    }

    @Override
    public Object getAccountInfo() {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAccountInfo());
    }

    @Override
    public Object getTransactionLog(AccountDataRequest getTransactionLogRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getUtaTransactionLog(getTransactionLogRequest.getAccountType() == null ? null : getTransactionLogRequest.getAccountType().getAccountTypeValue(), getTransactionLogRequest.getCategory() == null ? null : getTransactionLogRequest.getCategory().getCategoryTypeId(), getTransactionLogRequest.getCurrency(), getTransactionLogRequest.getBaseCoin(), null, getTransactionLogRequest.getStartTime(), getTransactionLogRequest.getEndTime(), getTransactionLogRequest.getLimit(), getTransactionLogRequest.getCursor()));
    }

    @Override
    public Object getAccountSMPGroup() {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAccountSMPGroupId());
    }

    @Override
    public Object getUserSettingConfig() {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getUserSettingConfig());
    }
}

