/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.asset.request.AssetCancelWithdrawRequest;
import com.abfinance.api.client.domain.asset.request.AssetDataRequest;
import com.abfinance.api.client.domain.asset.request.AssetInternalTransferRequest;
import com.abfinance.api.client.domain.asset.request.AssetUniversalTransferRequest;
import com.abfinance.api.client.domain.asset.request.AssetWithdrawRequest;
import com.abfinance.api.client.domain.asset.request.SetAssetDepositAccountRequest;
import com.abfinance.api.client.restApi.ABFinanceApiAssetRestClient;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;
import com.abfinance.api.client.service.ABFinanceJsonConverter;

public class ABFinanceApiAssetRestClientImpl
implements ABFinanceApiAssetRestClient {
    private final ABFinanceApiService apiService;
    private final ABFinanceJsonConverter converter = new ABFinanceJsonConverter();

    public ABFinanceApiAssetRestClientImpl(ABFinanceApiService apiService) {
        this.apiService = apiService;
    }

    public ABFinanceApiAssetRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public Object getAssetCoinInfo(AssetDataRequest request) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetCoinInfo(request.getCoin()));
    }

    @Override
    public Object setAssetDepositAccount(AssetDataRequest request) {
        SetAssetDepositAccountRequest setAssetDepositAccountRequest = this.converter.mapToSetDepositAccountRequest(request);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.setAssetDepositAccount(setAssetDepositAccountRequest));
    }

    @Override
    public Object getAssetMasterDepositAddress(AssetDataRequest masterDepositRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetMasterDepositAddress(masterDepositRequest.getCoin(), masterDepositRequest.getChainType()));
    }

    @Override
    public Object getAssetInternalDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetInternalDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetSubMemberDepositAddress(AssetDataRequest subDepositRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetSubMemberDepositAddress(subDepositRequest.getCoin(), subDepositRequest.getChainType(), subDepositRequest.getSubMemberId()));
    }

    @Override
    public Object getAssetSubMembersDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetSubMembersDepositRecords(assetDepositRecordsRequest.getSubMemberId(), assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object createAssetInternalTransfer(AssetDataRequest assetInternalTransferRequest) {
        AssetInternalTransferRequest request = this.converter.mapToAssetInternalTransferRequest(assetInternalTransferRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createAssetInternalTransfer(request));
    }

    @Override
    public Object getAssetSingleCoinBalance(AssetDataRequest singleCoinBalanceRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.converter.getSingleCoinBalance(this.apiService, singleCoinBalanceRequest));
    }

    @Override
    public Object getAssetAllCoinsBalance(AssetDataRequest allCoinsBalanceRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetAllCoinsBalance(allCoinsBalanceRequest.getAccountType() == null ? null : allCoinsBalanceRequest.getAccountType().getAccountTypeValue(), allCoinsBalanceRequest.getMemberId(), allCoinsBalanceRequest.getCoin(), allCoinsBalanceRequest.getWithBonus() == null ? null : String.valueOf(allCoinsBalanceRequest.getWithBonus().getValue())));
    }

    @Override
    public Object getAssetInternalTransferRecords(AssetDataRequest internalTransferRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetInternalTransferRecords(internalTransferRequest.getTransferId(), internalTransferRequest.getCoin(), internalTransferRequest.getTransferStatus() == null ? null : internalTransferRequest.getTransferStatus().getStatus(), internalTransferRequest.getStartTime(), internalTransferRequest.getEndTime(), internalTransferRequest.getLimit(), internalTransferRequest.getCursor()));
    }

    @Override
    public Object getAssetTransferSubUidList() {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetTransferSubUidList());
    }

    @Override
    public Object getAssetTransferableCoins(AssetDataRequest request) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetTransferableCoins(request.getFromAccountType() == null ? null : request.getFromAccountType().getAccountTypeValue(), request.getToAccountType() == null ? null : request.getToAccountType().getAccountTypeValue()));
    }

    @Override
    public Object getAssetUniversalTransferRecords(AssetDataRequest universalTransferRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetUniversalTransferRecords(universalTransferRequest.getTransferId(), universalTransferRequest.getCoin(), universalTransferRequest.getTransferStatus() == null ? null : universalTransferRequest.getTransferStatus().getStatus(), universalTransferRequest.getStartTime(), universalTransferRequest.getEndTime(), universalTransferRequest.getLimit(), universalTransferRequest.getCursor()));
    }

    @Override
    public Object createAssetUniversalTransfer(AssetDataRequest assetUniversalTransferRequest) {
        AssetUniversalTransferRequest request = this.converter.mapToAssetUniversalTransferRequest(assetUniversalTransferRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createAssetUniversalTransfer(request));
    }

    @Override
    public Object cancelAssetWithdraw(AssetDataRequest request) {
        AssetCancelWithdrawRequest assetCancelWithdrawRequest = this.converter.mapToAssetCancelWithdrawRequest(request);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.cancelAssetWithdraw(assetCancelWithdrawRequest));
    }

    @Override
    public Object createAssetWithdraw(AssetDataRequest assetWithdrawRequest) {
        AssetWithdrawRequest request = this.converter.mapToAssetWithdrawRequest(assetWithdrawRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createAssetWithdraw(request));
    }

    @Override
    public Object getAssetWithdrawAddress(AssetDataRequest request) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetWithdrawAddress(request.getCoin(), request.getChain(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getAssetWithdrawalRecords(AssetDataRequest assetWithdrawRecordsRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetWithdrawalRecords(assetWithdrawRecordsRequest.getWithdrawID(), assetWithdrawRecordsRequest.getCoin(), assetWithdrawRecordsRequest.getWithdrawType() == null ? null : Integer.valueOf(assetWithdrawRecordsRequest.getWithdrawType().getValue()), assetWithdrawRecordsRequest.getStartTime(), assetWithdrawRecordsRequest.getEndTime(), assetWithdrawRecordsRequest.getLimit(), assetWithdrawRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetWithdrawalAmount(AssetDataRequest request) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getAssetWithdrawalAmount(request.getCoin()));
    }

    @Override
    public Object getVaspList() {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getVaspList());
    }
}

