/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.earn.request.EarnDataRequest;
import com.abfinance.api.client.restApi.ABFinanceApiEarnRestClient;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;
import java.util.HashMap;

public class ABFinanceApiEarnRestClientImpl
implements ABFinanceApiEarnRestClient {
    private final ABFinanceApiService apiService;

    public ABFinanceApiEarnRestClientImpl(ABFinanceApiService apiService) {
        this.apiService = apiService;
    }

    public ABFinanceApiEarnRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public Object getEarnProduct(EarnDataRequest request) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getEarnProduct(request.getCategory(), request.getCoin(), request.getProductId(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getEarnPosition(EarnDataRequest request) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getEarnPosition(request.getCategory(), request.getCoin(), request.getProductId(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object placeEarnOrder(EarnDataRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getProductId() != null) {
            params.put("productId", request.getProductId());
        }
        if (request.getQuantity() != null) {
            params.put("quantity", request.getQuantity());
        }
        if (request.getAccountType() != null) {
            params.put("accountType", request.getAccountType());
        }
        if (request.getSerialNo() != null) {
            params.put("serialNo", request.getSerialNo());
        }
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.placeEarnOrder(params));
    }

    @Override
    public Object getEarnOrder(EarnDataRequest request) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getEarnOrder(request.getOrderId(), request.getOrderType(), request.getCategory(), request.getCoin(), request.getProductId(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }
}

