/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.market.request.MarketDataRequest;
import com.abfinance.api.client.restApi.ABFinanceApiMarketRestClient;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;
import lombok.Generated;

public class ABFinanceApiMarketRestClientImpl
implements ABFinanceApiMarketRestClient {
    private final ABFinanceApiService apiService;

    public ABFinanceApiMarketRestClientImpl(String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, baseUrl, debugMode, recvWindow, logOption);
    }

    @Override
    public Object getServerTime() {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getServerTime());
    }

    @Override
    public Object getMarketLinesData(MarketDataRequest marketKlineRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getMarketLinesData(marketKlineRequest.getCategory().getCategoryTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()));
    }

    @Override
    public Object getInstrumentsInfo(MarketDataRequest instrumentInfoRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getInstrumentsInfo(instrumentInfoRequest.getCategory().getCategoryTypeId(), instrumentInfoRequest.getSymbol(), instrumentInfoRequest.getInstrumentStatus() == null ? null : instrumentInfoRequest.getInstrumentStatus().getStatus(), instrumentInfoRequest.getBaseCoin(), instrumentInfoRequest.getLimit(), instrumentInfoRequest.getCursor()));
    }

    @Override
    public Object getMarketOrderBook(MarketDataRequest marketOrderBookRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getMarketOrderBook(marketOrderBookRequest.getCategory().getCategoryTypeId(), marketOrderBookRequest.getSymbol(), marketOrderBookRequest.getLimit()));
    }

    @Override
    public Object getMarketTickers(MarketDataRequest marketDataTickerRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getMarketTickers(marketDataTickerRequest.getCategory().getCategoryTypeId(), marketDataTickerRequest.getSymbol(), marketDataTickerRequest.getBaseCoin(), marketDataTickerRequest.getExpDate()));
    }

    @Override
    public Object getRecentTradeData(MarketDataRequest recentTradeRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getRecentTradeData(recentTradeRequest.getCategory().getCategoryTypeId(), recentTradeRequest.getSymbol(), recentTradeRequest.getBaseCoin(), recentTradeRequest.getOptionType() == null ? null : recentTradeRequest.getOptionType().getOpType(), recentTradeRequest.getLimit()));
    }

    @Generated
    public ABFinanceApiService getApiService() {
        return this.apiService;
    }
}

