/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.trade.request.AmendBatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.AmendOrderRequest;
import com.abfinance.api.client.domain.trade.request.BatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.CancelAllOrdersRequest;
import com.abfinance.api.client.domain.trade.request.CancelBatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.CancelOrderRequest;
import com.abfinance.api.client.domain.trade.request.PlaceBatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.PlaceOrderRequest;
import com.abfinance.api.client.domain.trade.request.SetDcpRequest;
import com.abfinance.api.client.domain.trade.request.TradeOrderRequest;
import com.abfinance.api.client.impl.ABFinanceApiCallbackAdapter;
import com.abfinance.api.client.restApi.ABFinanceApiAsyncTradeRestClient;
import com.abfinance.api.client.restApi.ABFinanceApiCallback;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;
import com.abfinance.api.client.service.ABFinanceJsonConverter;
import java.io.IOException;
import java.util.Map;

public class ABFinanceApiTradeAsyncRestClientImpl
implements ABFinanceApiAsyncTradeRestClient {
    private final ABFinanceApiService apiService;
    private final ABFinanceJsonConverter converter = new ABFinanceJsonConverter();

    public ABFinanceApiTradeAsyncRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption, String referer) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, referer);
    }

    @Override
    public void getOrderHistory(TradeOrderRequest orderHistoryRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getOrderHistory(orderHistoryRequest.getCategory().getCategoryTypeId(), orderHistoryRequest.getSymbol(), orderHistoryRequest.getBaseCoin(), orderHistoryRequest.getSettleCoin(), orderHistoryRequest.getOrderId(), orderHistoryRequest.getOrderLinkId(), orderHistoryRequest.getOrderFilter() == null ? null : orderHistoryRequest.getOrderFilter().getOrderFilterType(), orderHistoryRequest.getOrderStatus(), orderHistoryRequest.getStartTime(), orderHistoryRequest.getEndTime(), orderHistoryRequest.getLimit(), orderHistoryRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setDisconnectCancelAllTime(TradeOrderRequest orderRequest, ABFinanceApiCallback<Object> callback) {
        SetDcpRequest setDcpRequest = this.converter.convertMapToDcpRequest(orderRequest);
        this.apiService.setDisconnectCancelAllTime(setDcpRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getBorrowQuota(TradeOrderRequest borrowQuotaRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getBorrowQuota(borrowQuotaRequest.getCategory().getCategoryTypeId(), borrowQuotaRequest.getSymbol(), borrowQuotaRequest.getSide() == null ? null : borrowQuotaRequest.getSide().getTransactionSide()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getOpenOrders(TradeOrderRequest order, ABFinanceApiCallback<Object> callback) {
        this.apiService.getOpenOrders(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderId(), order.getOrderLinkId(), order.getOpenOnly(), order.getOrderFilter() == null ? null : order.getOrderFilter().getOrderFilterType(), order.getLimit(), order.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getTradeHistory(TradeOrderRequest order, ABFinanceApiCallback<Object> callback) {
        this.apiService.getTradeHistory(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getBaseCoin(), order.getStartTime(), order.getEndTime(), order.getExecType() == null ? null : order.getExecType().getExecTypeId(), order.getLimit(), order.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(TradeOrderRequest order, ABFinanceApiCallback<Object> callback) {
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(order);
        this.apiService.createOrder(placeOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(Map<String, Object> order, ABFinanceApiCallback<Object> callback) {
        TradeOrderRequest singleOrderRequest = this.converter.convertMapToSingleOrderRequest(order);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        this.apiService.createOrder(placeOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(String order, ABFinanceApiCallback<Object> callback) throws IOException {
        TradeOrderRequest singleOrderRequest = this.converter.convertJsonToSingleOrderRequest(order);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        this.apiService.createOrder(placeOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBatchOrder(BatchOrderRequest batchOrderRequest, ABFinanceApiCallback<Object> callback) {
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        this.apiService.createBatchOrder(placeBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBathOrder(Map<String, Object> payload, ABFinanceApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        this.apiService.createBatchOrder(placeBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBathOrder(String json, ABFinanceApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        this.apiService.createBatchOrder(placeBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(BatchOrderRequest batchOrderRequest, ABFinanceApiCallback<Object> callback) {
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        this.apiService.amendBatchOrder(amendBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(Map<String, Object> payload, ABFinanceApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        this.apiService.amendBatchOrder(amendBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(String json, ABFinanceApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        this.apiService.amendBatchOrder(amendBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(BatchOrderRequest batchOrderRequest, ABFinanceApiCallback<Object> callback) {
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        this.apiService.cancelBatchOrder(cancelBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(Map<String, Object> payload, ABFinanceApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        this.apiService.cancelBatchOrder(cancelBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(String json, ABFinanceApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        this.apiService.cancelBatchOrder(cancelBatchOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelOrder(TradeOrderRequest order, ABFinanceApiCallback<Object> callback) {
        CancelOrderRequest cancelOrderRequest = this.converter.convertTradeToCancelOrderRequest(order);
        this.apiService.cancelOrder(cancelOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelAllOrder(TradeOrderRequest order, ABFinanceApiCallback<Object> callback) {
        CancelAllOrdersRequest cancelAllOrderRequest = this.converter.convertTradeToCancelAllOrdersRequest(order);
        this.apiService.cancelAllOrder(cancelAllOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendOrder(TradeOrderRequest order, ABFinanceApiCallback<Object> callback) {
        AmendOrderRequest amendOrderRequest = this.converter.convertTradeToAmendOrderRequest(order);
        this.apiService.amendOrder(amendOrderRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }
}

