/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.security;

import com.abfinance.api.client.security.SignatureGenerator;
import com.abfinance.api.client.util.ParameterChecker;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;

public class HmacSHA256Signer
implements SignatureGenerator {
    private final String apiSecret;

    public HmacSHA256Signer(String apiSecret) {
        ParameterChecker.checkParameterType(apiSecret, String.class, "apiSecret");
        this.apiSecret = apiSecret;
    }

    public static String sign(String apiKey, String apiSecret, String payload, String timestamp, String recvWindow) {
        try {
            String message = timestamp + apiKey + recvWindow + payload;
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(apiSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            sha256_HMAC.init(secretKeySpec);
            byte[] hash = sha256_HMAC.doFinal(message.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])hash);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String auth(String data) {
        return HmacSHA256Signer.getSignatureString(data, this.apiSecret);
    }

    @NotNull
    private static String getSignatureString(String data, String apiSecret) {
        byte[] hmacSha256;
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(apiSecret.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            hmacSha256 = mac.doFinal(data.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate hmac-sha256", e);
        }
        return Hex.encodeHexString((byte[])hmacSha256);
    }

    public static String getSignature(String data, String secret) {
        return HmacSHA256Signer.getSignatureString(data, secret);
    }
}

