/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.service;

import com.abfinance.api.client.exception.ABFinanceApiError;
import com.abfinance.api.client.exception.ABFinanceApiException;
import com.abfinance.api.client.log.Slf4jLoggingInterceptor;
import com.abfinance.api.client.security.AuthenticationInterceptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ABFinanceApiServiceGenerator {
    private static final OkHttpClient sharedClient;
    private static final Converter.Factory converterFactory;
    @Nullable
    private static final Converter<ResponseBody, ABFinanceApiError> errorBodyConverter;

    public static <S> S createService(Class<S> serviceClass, String baseUrl, boolean debugMode, long recvWindow, String logOption, String referer) {
        return ABFinanceApiServiceGenerator.createService(serviceClass, null, null, baseUrl, debugMode, recvWindow, logOption, referer);
    }

    public static <S> S createService(Class<S> serviceClass, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        return ABFinanceApiServiceGenerator.createService(serviceClass, null, null, baseUrl, debugMode, recvWindow, logOption, "");
    }

    public static <S> S createService(Class<S> serviceClass, String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption, String referer) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory(converterFactory);
        OkHttpClient.Builder clientBuilder = sharedClient.newBuilder();
        if (!StringUtils.isEmpty((CharSequence)apiKey) && !StringUtils.isEmpty((CharSequence)secret)) {
            AuthenticationInterceptor interceptor = new AuthenticationInterceptor(apiKey, secret, recvWindow, referer);
            clientBuilder.addInterceptor((Interceptor)interceptor);
        }
        if (debugMode) {
            Slf4jLoggingInterceptor.HandleLoggingInterceptor(clientBuilder, logOption);
        }
        retrofitBuilder.client(clientBuilder.build());
        Retrofit retrofit = retrofitBuilder.build();
        return (S)retrofit.create(serviceClass);
    }

    public static <T> Object executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                Object body = response.body();
                if (body == null) {
                    throw new ABFinanceApiException("Empty response body received from API");
                }
                return body;
            }
            ABFinanceApiError apiError = ABFinanceApiServiceGenerator.getABFinanceApiError(response);
            throw new ABFinanceApiException(apiError);
        }
        catch (IOException e) {
            throw new ABFinanceApiException(e);
        }
    }

    public static ABFinanceApiError getABFinanceApiError(Response<?> response) throws IOException, ABFinanceApiException {
        ResponseBody errorBody = response.errorBody();
        if (errorBody != null && errorBodyConverter != null) {
            return (ABFinanceApiError)errorBodyConverter.convert((Object)errorBody);
        }
        throw new ABFinanceApiException("Response error body was null or couldn't be converted.");
    }

    @Generated
    public static OkHttpClient getSharedClient() {
        return sharedClient;
    }

    static {
        converterFactory = JacksonConverterFactory.create();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(1000);
        dispatcher.setMaxRequests(1000);
        sharedClient = new OkHttpClient.Builder().dispatcher(dispatcher).pingInterval(20L, TimeUnit.SECONDS).build();
        errorBodyConverter = converterFactory.responseBodyConverter(ABFinanceApiError.class, new Annotation[0], null);
    }
}

