/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.util;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public final class UrlBuilder {
    private static final int DIFF_TILL_POSITION_INDEX = 1;
    private static final int MAX_DECIMAL_DIGITS = 30;
    private static DecimalFormat df;

    private UrlBuilder() {
    }

    public static String buildFullUrl(String baseUrl, String urlPath, Map<String, Object> parameters) {
        StringBuilder sb = new StringBuilder(baseUrl).append(urlPath);
        if (parameters != null && !parameters.isEmpty()) {
            sb.append("?");
            sb.append(UrlBuilder.joinQueryParameters(parameters));
        }
        return sb.toString();
    }

    public static String buildStreamUrl(String baseUrl, ArrayList<String> streams) {
        StringBuilder sb = new StringBuilder(baseUrl).append("/stream");
        if (streams != null && !streams.isEmpty()) {
            sb.append("?streams=");
            sb.append(UrlBuilder.joinStreamUrls(streams));
        }
        return sb.toString();
    }

    public static String joinQueryParameters(Map<String, Object> params) {
        return UrlBuilder.joinQueryParameters(new StringBuilder(), params).toString();
    }

    public static StringBuilder joinQueryParameters(StringBuilder sb, Map<String, Object> params) {
        if (params != null && !params.isEmpty()) {
            for (String key : params.keySet()) {
                sb.append(key);
                sb.append("=");
                String value = params.get(key) instanceof Double ? UrlBuilder.getFormatter().format(params.get(key)) : params.get(key).toString();
                sb.append(UrlBuilder.urlEncode(value));
                sb.append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String joinStreamUrls(ArrayList<String> streams) {
        return UrlBuilder.joinStreamUrls(new StringBuilder(), streams).toString();
    }

    public static StringBuilder joinStreamUrls(StringBuilder sb, ArrayList<String> streams) {
        if (streams != null && !streams.isEmpty()) {
            for (String stream : streams) {
                sb.append(stream);
                sb.append("/");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    public static String buildTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    private static DecimalFormat getFormatter() {
        if (null == df) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
            df = new DecimalFormat("#,##0.###", symbols);
            df.setMaximumFractionDigits(30);
            df.setGroupingUsed(false);
        }
        return df;
    }
}

