/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.websocket.impl;

import com.abfinance.api.client.exception.ABFinanceApiException;
import com.abfinance.api.client.websocket.api.WebSocketApiAuth;
import com.abfinance.api.client.websocket.api.WebSocketApiModule;
import com.abfinance.api.client.websocket.api.WebSocketApiTrade;
import com.abfinance.api.client.websocket.callback.WebSocketApiRequestHandler;
import com.abfinance.api.client.websocket.enums.Category;

public final class WebSocketApiModuleFactory {
    private static WebSocketApiAuth wsApiAuth;
    private static WebSocketApiTrade wsApiTrade;

    private WebSocketApiModuleFactory() {
    }

    private static WebSocketApiModule obtainModule(WebSocketApiModule module, ModuleCreator creator) {
        if (module == null) {
            module = creator.create();
        }
        return module;
    }

    public static WebSocketApiModule build(Category category, WebSocketApiRequestHandler requestHandler) {
        switch (category) {
            case AUTH: {
                return WebSocketApiModuleFactory.obtainModule(wsApiAuth, () -> new WebSocketApiAuth(requestHandler));
            }
            case TRADE: {
                return WebSocketApiModuleFactory.obtainModule(wsApiTrade, () -> new WebSocketApiTrade(requestHandler));
            }
        }
        throw new ABFinanceApiException("Unknown WebSocket API Category: " + String.valueOf((Object)category));
    }

    private static interface ModuleCreator {
        public WebSocketApiModule create();
    }
}

