package com.abfinance.api.client.domain.market.request;

import com.abfinance.api.client.domain.CategoryType;
import com.abfinance.api.client.domain.market.*;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@Builder
@JsonInclude(JsonInclude.Include.NON_NULL)
public class MarketDataRequest {
    private CategoryType category; // always required
    private String coin;
    private String symbol;
    private String baseCoin;
    private String expDate;
    private InstrumentStatus instrumentStatus;
    private MarketStatus marketStatus;
    private IntervalTime marketIntervalTime;
    private MarketInterval marketInterval; // open interest interval time
    private OptionType optionType; // option only
    private Integer optionPeriod; // option only
    private DataRecordingPeriod dataRecordingPeriod;
    private Long startTime;
    private Long endTime;
    private Long start;
    private Long end;
    private Integer limit;
    private String cursor;
    @Builder.Default
    private int page = 1;
}
