/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.account.request.AccountDataRequest;
import com.abfinance.api.client.impl.ABFinanceApiCallbackAdapter;
import com.abfinance.api.client.restApi.ABFinanceApiAsyncAccountRestClient;
import com.abfinance.api.client.restApi.ABFinanceApiCallback;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;

public class ABFinanceApiAsyncAccountRestClientImpl
implements ABFinanceApiAsyncAccountRestClient {
    private final ABFinanceApiService apiService;

    public ABFinanceApiAsyncAccountRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public void getWalletBalance(AccountDataRequest walletBalanceRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getWalletBalance(walletBalanceRequest.getAccountType().getAccountTypeValue(), walletBalanceRequest.getCoins()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountFreeRate(AccountDataRequest getFeeRateRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAccountFreeRate(getFeeRateRequest.getCategory().getCategoryTypeId(), getFeeRateRequest.getSymbol(), getFeeRateRequest.getBaseCoin()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountInfo(ABFinanceApiCallback<Object> callback) {
        this.apiService.getAccountInfo().enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getTransactionLog(AccountDataRequest getTransactionLogRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getUtaTransactionLog(getTransactionLogRequest.getAccountType() == null ? null : getTransactionLogRequest.getAccountType().getAccountTypeValue(), getTransactionLogRequest.getCategory() == null ? null : getTransactionLogRequest.getCategory().getCategoryTypeId(), getTransactionLogRequest.getCurrency(), getTransactionLogRequest.getBaseCoin(), null, getTransactionLogRequest.getStartTime(), getTransactionLogRequest.getEndTime(), getTransactionLogRequest.getLimit(), getTransactionLogRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountSMPGroup(ABFinanceApiCallback<Object> callback) {
        this.apiService.getAccountSMPGroupId().enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getUserSettingConfig(ABFinanceApiCallback<Object> callback) {
        this.apiService.getUserSettingConfig().enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }
}

