/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.asset.request.AssetCancelWithdrawRequest;
import com.abfinance.api.client.domain.asset.request.AssetDataRequest;
import com.abfinance.api.client.domain.asset.request.AssetInternalTransferRequest;
import com.abfinance.api.client.domain.asset.request.AssetUniversalTransferRequest;
import com.abfinance.api.client.domain.asset.request.AssetWithdrawRequest;
import com.abfinance.api.client.domain.asset.request.SetAssetDepositAccountRequest;
import com.abfinance.api.client.impl.ABFinanceApiCallbackAdapter;
import com.abfinance.api.client.restApi.ABFinanceApiAsyncAssetRestClient;
import com.abfinance.api.client.restApi.ABFinanceApiCallback;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;
import com.abfinance.api.client.service.ABFinanceJsonConverter;

public class ABFinanceApiAsyncAssetRestClientImpl
implements ABFinanceApiAsyncAssetRestClient {
    private final ABFinanceApiService apiService;
    private final ABFinanceJsonConverter converter = new ABFinanceJsonConverter();

    public ABFinanceApiAsyncAssetRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public void getAssetCoinInfo(AssetDataRequest request, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetCoinInfo(request.getCoin()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAssetDepositAccount(AssetDataRequest request, ABFinanceApiCallback<Object> callback) {
        SetAssetDepositAccountRequest setAssetDepositAccountRequest = this.converter.mapToSetDepositAccountRequest(request);
        this.apiService.setAssetDepositAccount(setAssetDepositAccountRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetMasterDepositAddress(AssetDataRequest masterDepositRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetMasterDepositAddress(masterDepositRequest.getCoin(), masterDepositRequest.getChainType()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInternalDepositRecords(AssetDataRequest assetDepositRecordsRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetInternalDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetDepositRecords(AssetDataRequest assetDepositRecordsRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSubMemberDepositAddress(AssetDataRequest subDepositRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetSubMemberDepositAddress(subDepositRequest.getCoin(), subDepositRequest.getChainType(), subDepositRequest.getSubMemberId()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSubMembersDepositRecords(AssetDataRequest assetDepositRecordsRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetSubMembersDepositRecords(assetDepositRecordsRequest.getSubMemberId(), assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetInternalTransfer(AssetDataRequest assetInternalTransferRequest, ABFinanceApiCallback<Object> callback) {
        AssetInternalTransferRequest request = this.converter.mapToAssetInternalTransferRequest(assetInternalTransferRequest);
        this.apiService.createAssetInternalTransfer(request).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSingleCoinBalance(AssetDataRequest singleCoinBalanceRequest, ABFinanceApiCallback<Object> callback) {
        this.converter.getSingleCoinBalance(this.apiService, singleCoinBalanceRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetAllCoinsBalance(AssetDataRequest allCoinsBalanceRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetAllCoinsBalance(allCoinsBalanceRequest.getAccountType() == null ? null : allCoinsBalanceRequest.getAccountType().getAccountTypeValue(), allCoinsBalanceRequest.getMemberId(), allCoinsBalanceRequest.getCoin(), allCoinsBalanceRequest.getWithBonus() == null ? null : String.valueOf(allCoinsBalanceRequest.getWithBonus().getValue())).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInternalTransferRecords(AssetDataRequest internalTransferRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetInternalTransferRecords(internalTransferRequest.getTransferId(), internalTransferRequest.getCoin(), internalTransferRequest.getTransferStatus() == null ? null : internalTransferRequest.getTransferStatus().getStatus(), internalTransferRequest.getStartTime(), internalTransferRequest.getEndTime(), internalTransferRequest.getLimit(), internalTransferRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetTransferSubUidList(ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetTransferSubUidList().enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetTransferableCoins(AssetDataRequest request, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetTransferableCoins(request.getFromAccountType() == null ? null : request.getFromAccountType().getAccountTypeValue(), request.getToAccountType() == null ? null : request.getToAccountType().getAccountTypeValue()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetUniversalTransferRecords(AssetDataRequest universalTransferRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetUniversalTransferRecords(universalTransferRequest.getTransferId(), universalTransferRequest.getCoin(), universalTransferRequest.getTransferStatus() == null ? null : universalTransferRequest.getTransferStatus().getStatus(), universalTransferRequest.getStartTime(), universalTransferRequest.getEndTime(), universalTransferRequest.getLimit(), universalTransferRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetUniversalTransfer(AssetDataRequest assetUniversalTransferRequest, ABFinanceApiCallback<Object> callback) {
        AssetUniversalTransferRequest request = this.converter.mapToAssetUniversalTransferRequest(assetUniversalTransferRequest);
        this.apiService.createAssetUniversalTransfer(request).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelAssetWithdraw(AssetDataRequest request, ABFinanceApiCallback<Object> callback) {
        AssetCancelWithdrawRequest assetCancelWithdrawRequest = this.converter.mapToAssetCancelWithdrawRequest(request);
        this.apiService.cancelAssetWithdraw(assetCancelWithdrawRequest).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetWithdraw(AssetDataRequest assetWithdrawRequest, ABFinanceApiCallback<Object> callback) {
        AssetWithdrawRequest request = this.converter.mapToAssetWithdrawRequest(assetWithdrawRequest);
        this.apiService.createAssetWithdraw(request).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetWithdrawAddress(AssetDataRequest request, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetWithdrawAddress(request.getCoin(), request.getChain(), request.getLimit(), request.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetWithdrawalRecords(AssetDataRequest assetWithdrawRecordsRequest, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetWithdrawalRecords(assetWithdrawRecordsRequest.getWithdrawID(), assetWithdrawRecordsRequest.getCoin(), assetWithdrawRecordsRequest.getWithdrawType() == null ? null : Integer.valueOf(assetWithdrawRecordsRequest.getWithdrawType().getValue()), assetWithdrawRecordsRequest.getStartTime(), assetWithdrawRecordsRequest.getEndTime(), assetWithdrawRecordsRequest.getLimit(), assetWithdrawRecordsRequest.getCursor()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetWithdrawalAmount(AssetDataRequest request, ABFinanceApiCallback<Object> callback) {
        this.apiService.getAssetWithdrawalAmount(request.getCoin()).enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getVaspList(ABFinanceApiCallback<Object> callback) {
        this.apiService.getVaspList().enqueue(new ABFinanceApiCallbackAdapter<Object>(callback));
    }
}

