/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.exception.ABFinanceApiError;
import com.abfinance.api.client.exception.ABFinanceApiException;
import com.abfinance.api.client.restApi.ABFinanceApiCallback;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class ABFinanceApiCallbackAdapter<T>
implements Callback<T> {
    private final ABFinanceApiCallback<T> callback;

    public ABFinanceApiCallbackAdapter(ABFinanceApiCallback<T> callback) {
        this.callback = callback;
    }

    public void onResponse(@NotNull Call<T> call, Response<T> response) {
        if (response.isSuccessful()) {
            this.callback.onResponse(response.body());
        } else {
            if (response.code() == 504) {
                this.onFailure(call, new ABFinanceApiException("Request timeout (504): execution status is UNKNOWN and could have been a success."));
                return;
            }
            try {
                ABFinanceApiError apiError = ABFinanceApiServiceGenerator.getABFinanceApiError(response);
                this.onFailure(call, new ABFinanceApiException(apiError));
            }
            catch (IOException e) {
                this.onFailure(call, new ABFinanceApiException(e));
            }
        }
    }

    public void onFailure(@NotNull Call<T> call, @NotNull Throwable throwable) {
        if (throwable instanceof ABFinanceApiException) {
            this.callback.onFailure(throwable);
        } else {
            this.callback.onFailure(new ABFinanceApiException(throwable));
        }
    }
}

