/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.impl;

import com.abfinance.api.client.domain.trade.request.AmendBatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.AmendOrderRequest;
import com.abfinance.api.client.domain.trade.request.BatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.CancelAllOrdersRequest;
import com.abfinance.api.client.domain.trade.request.CancelBatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.CancelOrderRequest;
import com.abfinance.api.client.domain.trade.request.PlaceBatchOrderRequest;
import com.abfinance.api.client.domain.trade.request.PlaceOrderRequest;
import com.abfinance.api.client.domain.trade.request.SetDcpRequest;
import com.abfinance.api.client.domain.trade.request.TradeOrderRequest;
import com.abfinance.api.client.restApi.ABFinanceApiService;
import com.abfinance.api.client.restApi.ABFinanceApiTradeRestClient;
import com.abfinance.api.client.service.ABFinanceApiServiceGenerator;
import com.abfinance.api.client.service.ABFinanceJsonConverter;
import java.io.IOException;
import java.util.Map;

public class ABFinanceApiTradeRestClientImpl
implements ABFinanceApiTradeRestClient {
    private final ABFinanceApiService apiService;
    private final ABFinanceJsonConverter converter = new ABFinanceJsonConverter();

    public ABFinanceApiTradeRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption, String referer) {
        this.apiService = ABFinanceApiServiceGenerator.createService(ABFinanceApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, referer);
    }

    @Override
    public Object setDisconnectCancelAllTime(TradeOrderRequest tradeOrderRequest) {
        SetDcpRequest setDcpRequest = this.converter.convertMapToDcpRequest(tradeOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.setDisconnectCancelAllTime(setDcpRequest));
    }

    @Override
    public Object getBorrowQuota(TradeOrderRequest borrowQuotaRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getBorrowQuota(borrowQuotaRequest.getCategory().getCategoryTypeId(), borrowQuotaRequest.getSymbol(), borrowQuotaRequest.getSide() == null ? null : borrowQuotaRequest.getSide().getTransactionSide()));
    }

    @Override
    public Object getOrderHistory(TradeOrderRequest orderHistoryRequest) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getOrderHistory(orderHistoryRequest.getCategory().getCategoryTypeId(), orderHistoryRequest.getSymbol(), orderHistoryRequest.getBaseCoin(), orderHistoryRequest.getSettleCoin(), orderHistoryRequest.getOrderId(), orderHistoryRequest.getOrderLinkId(), orderHistoryRequest.getOrderFilter() == null ? null : orderHistoryRequest.getOrderFilter().getOrderFilterType(), orderHistoryRequest.getOrderStatus(), orderHistoryRequest.getStartTime(), orderHistoryRequest.getEndTime(), orderHistoryRequest.getLimit(), orderHistoryRequest.getCursor()));
    }

    @Override
    public Object createOrder(TradeOrderRequest tradeOrderRequest) {
        PlaceOrderRequest singleOrderRequest = this.converter.convertTradeToPlaceOrderRequest(tradeOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createOrder(singleOrderRequest));
    }

    @Override
    public Object createOrder(Map<String, Object> payload) {
        TradeOrderRequest singleOrderRequest = this.converter.convertMapToSingleOrderRequest(payload);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createOrder(placeOrderRequest));
    }

    @Override
    public Object createOrder(String json) throws IOException {
        TradeOrderRequest singleOrderRequest = this.converter.convertJsonToSingleOrderRequest(json);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createOrder(placeOrderRequest));
    }

    @Override
    public Object createBatchOrder(BatchOrderRequest batchOrderRequest) {
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createBatchOrder(placeBatchOrderRequest));
    }

    @Override
    public Object createBathOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createBatchOrder(placeBatchOrderRequest));
    }

    @Override
    public Object createBathOrder(String jsonRequest) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(jsonRequest);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.createBatchOrder(placeBatchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(BatchOrderRequest batchOrderRequest) {
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.amendBatchOrder(amendBatchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.amendBatchOrder(amendBatchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(String jsonRequest) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(jsonRequest);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.amendBatchOrder(amendBatchOrderRequest));
    }

    @Override
    public Object amendOrder(TradeOrderRequest order) {
        AmendOrderRequest amendOrderRequest = this.converter.convertTradeToAmendOrderRequest(order);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.amendOrder(amendOrderRequest));
    }

    @Override
    public Object cancelOrder(TradeOrderRequest order) {
        CancelOrderRequest cancelOrderRequest = this.converter.convertTradeToCancelOrderRequest(order);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.cancelOrder(cancelOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(BatchOrderRequest batchOrderRequest) {
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.cancelBatchOrder(cancelBatchOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.cancelBatchOrder(cancelBatchOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(String json) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.cancelBatchOrder(cancelBatchOrderRequest));
    }

    @Override
    public Object cancelAllOrder(TradeOrderRequest order) {
        CancelAllOrdersRequest cancelAllOrderRequest = this.converter.convertTradeToCancelAllOrdersRequest(order);
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.cancelAllOrder(cancelAllOrderRequest));
    }

    @Override
    public Object getOpenOrders(TradeOrderRequest order) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getOpenOrders(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderId(), order.getOrderLinkId(), order.getOpenOnly(), order.getOrderFilter() == null ? null : order.getOrderFilter().getOrderFilterType(), order.getLimit(), order.getCursor()));
    }

    @Override
    public Object getTradeHistory(TradeOrderRequest order) {
        return ABFinanceApiServiceGenerator.executeSync(this.apiService.getTradeHistory(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getBaseCoin(), order.getStartTime(), order.getEndTime(), order.getExecType() == null ? null : order.getExecType().getExecTypeId(), order.getLimit(), order.getCursor()));
    }
}

