/*
 * Decompiled with CFR 0.152.
 */
package com.abfinance.api.client.websocket.impl;

import com.abfinance.api.client.exception.ABFinanceApiException;
import com.abfinance.api.client.security.SignatureGenerator;
import com.abfinance.api.client.util.RequestBuilder;
import com.abfinance.api.client.websocket.api.WebSocketApiAuth;
import com.abfinance.api.client.websocket.api.WebSocketApiTrade;
import com.abfinance.api.client.websocket.callback.WebSocketApiRequestHandler;
import com.abfinance.api.client.websocket.callback.WebSocketClosedCallback;
import com.abfinance.api.client.websocket.callback.WebSocketClosingCallback;
import com.abfinance.api.client.websocket.callback.WebSocketFailureCallback;
import com.abfinance.api.client.websocket.callback.WebSocketMessageCallback;
import com.abfinance.api.client.websocket.callback.WebSocketOpenCallback;
import com.abfinance.api.client.websocket.enums.Category;
import com.abfinance.api.client.websocket.httpclient.WebSocketApiClient;
import com.abfinance.api.client.websocket.httpclient.WebSocketApiHttpClientSingleton;
import com.abfinance.api.client.websocket.impl.WebSocketApiModuleFactory;
import com.abfinance.api.client.websocket.impl.WebSocketConnection;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class WebSocketApiClientImpl
implements WebSocketApiClient {
    private static final OkHttpClient client = WebSocketApiHttpClientSingleton.getHttpClient();
    private final SignatureGenerator signatureGenerator;
    private final String apiKey;
    private final String baseUrl;
    private final WebSocketOpenCallback noopOpenCallback = response -> {};
    private final WebSocketClosingCallback noopClosingCallback = (code, reason) -> {};
    private final WebSocketClosedCallback noopClosedCallback = (code, reason) -> {};
    private final WebSocketFailureCallback noopFailureCallback = (throwable, response) -> {};
    private WebSocketConnection connection;
    private WebSocketApiRequestHandler requestHandler;

    public WebSocketApiClientImpl() {
        this("", null);
    }

    public WebSocketApiClientImpl(String baseUrl) {
        this("", null, baseUrl);
    }

    public WebSocketApiClientImpl(String apiKey, SignatureGenerator signatureGenerator) {
        this(apiKey, signatureGenerator, "wss://stream.abfinance.com/v5/trade");
    }

    public WebSocketApiClientImpl(String apiKey, SignatureGenerator signatureGenerator, String baseUrl) {
        this.apiKey = apiKey;
        this.signatureGenerator = signatureGenerator;
        this.baseUrl = baseUrl;
    }

    private void checkRequestHandler() {
        if (this.requestHandler == null) {
            throw new ABFinanceApiException("No WebSocket API connection to submit request. Please connect first.");
        }
    }

    @Override
    public void connect(WebSocketOpenCallback onOpenCallback, WebSocketMessageCallback onMessageCallback, WebSocketClosingCallback onClosingCallback, WebSocketClosedCallback onClosedCallback, WebSocketFailureCallback onFailureCallback) {
        Request request = RequestBuilder.buildWebSocketRequest(this.baseUrl);
        this.connection = new WebSocketConnection(onOpenCallback, onMessageCallback, onClosingCallback, onClosedCallback, onFailureCallback, request, client);
        this.requestHandler = new WebSocketApiRequestHandler(this.connection, this.apiKey, this.signatureGenerator);
        this.connection.connect();
    }

    @Override
    public void connect(WebSocketMessageCallback onMessageCallback) {
        this.connect(this.noopOpenCallback, onMessageCallback, this.noopClosingCallback, this.noopClosedCallback, this.noopFailureCallback);
    }

    @Override
    public void close() {
        this.connection.close();
        client.dispatcher().executorService().shutdown();
    }

    @Override
    public WebSocketApiAuth auth() {
        this.checkRequestHandler();
        return (WebSocketApiAuth)WebSocketApiModuleFactory.build(Category.AUTH, this.requestHandler);
    }

    @Override
    public WebSocketApiTrade trade() {
        this.checkRequestHandler();
        return (WebSocketApiTrade)WebSocketApiModuleFactory.build(Category.TRADE, this.requestHandler);
    }
}

