/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.broker.request.BrokerDataRequest;
import com.bybit.api.client.domain.broker.request.BrokerGetIssuedVoucherRequest;
import com.bybit.api.client.domain.broker.request.BrokerIssueVoucherRequest;
import com.bybit.api.client.domain.broker.request.BrokerVoucherSpecRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncBrokerRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncBrokerRestClientImpl
implements BybitApiAsyncBrokerRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncBrokerRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public void getBrokerEarningData(BrokerDataRequest brokerEarningRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getBrokerEarningData(brokerEarningRequest.getBizType() == null ? null : brokerEarningRequest.getBizType().getType(), brokerEarningRequest.getStartTime(), brokerEarningRequest.getEndTime(), brokerEarningRequest.getLimit(), brokerEarningRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getBrokerAccountInfo(BybitApiCallback<Object> callback) {
        this.bybitApiService.getBrokerAccountInfo().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSubAccountsDeposits(BrokerDataRequest brokerDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getBrokerSubDeposits(brokerDataRequest.getSubMemberId(), brokerDataRequest.getCoin(), brokerDataRequest.getStartTime(), brokerDataRequest.getEndTime(), brokerDataRequest.getLimit(), brokerDataRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSubAccountsDeposits(BybitApiCallback<Object> callback) {
        this.bybitApiService.getBrokerSubDeposits().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getVoucherSpec(BrokerDataRequest voucherSpecRequest, BybitApiCallback<Object> callback) {
        BrokerVoucherSpecRequest request = this.converter.mapToBrokerVoucherSpecRequest(voucherSpecRequest);
        this.bybitApiService.getVoucherSpec(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void issueVoucher(BrokerDataRequest issueVoucherRequest, BybitApiCallback<Object> callback) {
        BrokerIssueVoucherRequest request = this.converter.mapToBrokerIssueVoucherRequest(issueVoucherRequest);
        this.bybitApiService.issueVoucher(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getIssuedVoucher(BrokerDataRequest getIssuedVoucherRequest, BybitApiCallback<Object> callback) {
        BrokerGetIssuedVoucherRequest request = this.converter.mapToBrokerGetIssuedVoucherRequest(getIssuedVoucherRequest);
        this.bybitApiService.getIssuedVoucher(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

