/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.institution.LendingDataRequest;
import com.bybit.api.client.domain.institution.insLending.UpdateInstitutionLoadUidRequest;
import com.bybit.api.client.restApi.BybitApiLendingRestClient;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiLendingRestClientImpl
implements BybitApiLendingRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiLendingRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public Object getInsProductInfo(LendingDataRequest lendingDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsProductInfo(lendingDataRequest.getProductId()));
    }

    @Override
    public Object getInsMarginCoinInfo(LendingDataRequest lendingDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsMarginCoinInfo(lendingDataRequest.getProductId()));
    }

    @Override
    public Object getInsLoanOrders(LendingDataRequest institutionLoanOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsLoanOrders(institutionLoanOrdersRequest.getOrderId(), institutionLoanOrdersRequest.getStartTime(), institutionLoanOrdersRequest.getEndTime(), institutionLoanOrdersRequest.getLimit()));
    }

    @Override
    public Object getInsRepayOrders(LendingDataRequest institutionRepayOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsRepayOrders(institutionRepayOrdersRequest.getStartTime(), institutionRepayOrdersRequest.getEndTime(), institutionRepayOrdersRequest.getLimit()));
    }

    @Override
    public Object getInsLoanToValue() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsLoanToValue());
    }

    @Override
    public Object updateInstitutionLoanUid(LendingDataRequest lendingDataRequest) {
        UpdateInstitutionLoadUidRequest updateInstitutionLoanUidRequest = this.converter.convertToUpdateInsUidRequest(lendingDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.updateInstitutionLoanUid(updateInstitutionLoanUidRequest));
    }
}

