/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.trade.request;

import com.bybit.api.client.domain.CategoryType;
import com.bybit.api.client.domain.trade.request.PlaceOrderRequest;
import com.bybit.api.client.service.CategoryTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

public class PlaceBatchOrderRequest {
    @JsonSerialize(using=CategoryTypeSerializer.class)
    private CategoryType category;
    private List<PlaceOrderRequest> request;

    PlaceBatchOrderRequest(CategoryType category, List<PlaceOrderRequest> request) {
        this.category = category;
        this.request = request;
    }

    public static PlaceBatchOrderRequestBuilder builder() {
        return new PlaceBatchOrderRequestBuilder();
    }

    public CategoryType getCategory() {
        return this.category;
    }

    public List<PlaceOrderRequest> getRequest() {
        return this.request;
    }

    public void setCategory(CategoryType category) {
        this.category = category;
    }

    public void setRequest(List<PlaceOrderRequest> request) {
        this.request = request;
    }

    public String toString() {
        return "PlaceBatchOrderRequest(category=" + String.valueOf((Object)this.getCategory()) + ", request=" + String.valueOf(this.getRequest()) + ")";
    }

    public static class PlaceBatchOrderRequestBuilder {
        private CategoryType category;
        private List<PlaceOrderRequest> request;

        PlaceBatchOrderRequestBuilder() {
        }

        public PlaceBatchOrderRequestBuilder category(CategoryType category) {
            this.category = category;
            return this;
        }

        public PlaceBatchOrderRequestBuilder request(List<PlaceOrderRequest> request) {
            this.request = request;
            return this;
        }

        public PlaceBatchOrderRequest build() {
            return new PlaceBatchOrderRequest(this.category, this.request);
        }

        public String toString() {
            return "PlaceBatchOrderRequest.PlaceBatchOrderRequestBuilder(category=" + String.valueOf((Object)this.category) + ", request=" + String.valueOf(this.request) + ")";
        }
    }
}

