/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.spot.SpotMarginDataRequest;
import com.bybit.api.client.domain.spot.leverageToken.SpotLeverageTokenRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeBorrowRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeRePayRequest;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.restApi.BybitApiSpotMarginRestClient;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;
import java.util.HashMap;
import java.util.Map;

public class BybitApiSpotMarginRestClientImpl
implements BybitApiSpotMarginRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiSpotMarginRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public Object getSpotLeverageTokenInfo(SpotMarginDataRequest spotMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageTokenInfo(spotMarginDataRequest.getLtCoin()));
    }

    @Override
    public Object getSpotLeverageTokenMarket(SpotMarginDataRequest spotMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageTokenMarket(spotMarginDataRequest.getLtCoin()));
    }

    @Override
    public Object purchaseSpotLeverageToken(SpotMarginDataRequest spotMarginDataRequest) {
        SpotLeverageTokenRequest spotLeverageTokenRequest = this.converter.mapToSpotLeverageTokenRequest(spotMarginDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.purchaseSpotLeverageToken(spotLeverageTokenRequest));
    }

    @Override
    public Object redeemSpotLeverageToken(SpotMarginDataRequest spotMarginDataRequest) {
        SpotLeverageTokenRequest spotLeverageTokenRequest = this.converter.mapToSpotLeverageTokenRequest(spotMarginDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.redeemSpotLeverageToken(spotLeverageTokenRequest));
    }

    @Override
    public Object getSpotLeverageRecords(SpotMarginDataRequest spotLeverageOrdersRecordRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageRecords(spotLeverageOrdersRecordRequest.getLtCoin(), spotLeverageOrdersRecordRequest.getOrderId(), spotLeverageOrdersRecordRequest.getStartTime(), spotLeverageOrdersRecordRequest.getEndTime(), spotLeverageOrdersRecordRequest.getLimit(), spotLeverageOrdersRecordRequest.getLtOrderType(), spotLeverageOrdersRecordRequest.getSerialNo()));
    }

    @Override
    public Object getUtaVipSpotMarginTradeData(SpotMarginDataRequest utaMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getUtaVipSpotMarginTradeData(utaMarginDataRequest.getVipLevel() == null ? null : utaMarginDataRequest.getVipLevel().getLevel(), utaMarginDataRequest.getCurrency()));
    }

    @Override
    public Object setUTASpotMarginTrade(String mode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spotMarginMode", mode);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setUTASpotMarginTrade(map));
    }

    @Override
    public Object setUTASpotMarginTradeLeverage(String leverage) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("leverage", leverage);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setUTASpotMarginTradeLeverage(map));
    }

    @Override
    public Object setUTASpotMarginTradeAutoRepayMode(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setUTASpotMarginTradeAutoRepayMode(request));
    }

    @Override
    public Object getUTASpotMarginTradeAutoRepayMode(Map<String, Object> utaMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getUTASpotMarginTradeAutoRepayMode(utaMarginDataRequest));
    }

    @Override
    public Object getUTASpotMarginTradeLeverageState() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getUTASpotMarginTradeLeverageState());
    }

    @Override
    @Deprecated
    public Object getNormalVipSpotMarginTradeData(SpotMarginDataRequest normalMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalVipSpotMarginTradeData(normalMarginDataRequest.getVipLevel() == null ? null : normalMarginDataRequest.getVipLevel().getLevel(), normalMarginDataRequest.getCurrency()));
    }

    @Override
    @Deprecated
    public Object getNormalSpotMarginTradeCoinInfo(SpotMarginDataRequest normalMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeCoinInfo(normalMarginDataRequest.getCoin()));
    }

    @Override
    @Deprecated
    public Object getNormalSpotMarginTradeBorrowCoinInfo(SpotMarginDataRequest normalMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeBorrowCoinInfo(normalMarginDataRequest.getCoin()));
    }

    @Override
    @Deprecated
    public Object getNormalSpotMarginTradeInterestQuota(SpotMarginDataRequest spotMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeInterestQuota(spotMarginDataRequest.getCoin()));
    }

    @Override
    @Deprecated
    public Object getNormalSpotMarginTradeAccountInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeAccountInfo());
    }

    @Override
    @Deprecated
    public Object setNormalSpotToggleMarginTrade(SpotMarginDataRequest spotMarginDataRequest) {
        int switchStatus = spotMarginDataRequest.getSwitchStatus() == null ? 0 : spotMarginDataRequest.getSwitchStatus().getValue();
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setNormalSpotToggleMarginTrade(switchStatus));
    }

    @Override
    @Deprecated
    public Object loanNormalSpotMarginTrade(SpotMarginDataRequest spotMarginDataRequest) {
        SpotMarginTradeBorrowRequest spotMarginTradeBorrowRequest = this.converter.mapToSpotMarginBorrowRequest(spotMarginDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.loanNormalSpotMarginTrade(spotMarginTradeBorrowRequest));
    }

    @Override
    @Deprecated
    public Object repayNormalSpotMarginTrade(SpotMarginDataRequest spotMarginDataRequest) {
        SpotMarginTradeRePayRequest spotMarginTradeRePayRequest = this.converter.mapToSpotMarginRepayRequest(spotMarginDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.repayNormalSpotMarginTrade(spotMarginTradeRePayRequest));
    }

    @Override
    @Deprecated
    public Object getNormalSpotMarginTradeBorrowOrders(SpotMarginDataRequest spotMarginTradeBorrowOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalMarginTradeBorrowOrders(spotMarginTradeBorrowOrdersRequest.getStartTime(), spotMarginTradeBorrowOrdersRequest.getEndTime(), spotMarginTradeBorrowOrdersRequest.getCoin(), spotMarginTradeBorrowOrdersRequest.getBorrowStatus() == null ? 0 : spotMarginTradeBorrowOrdersRequest.getBorrowStatus().getValue(), spotMarginTradeBorrowOrdersRequest.getLimit()));
    }

    @Override
    @Deprecated
    public Object getNormalSpotMarginTradeRepayOrders(SpotMarginDataRequest spotMarginTradeRepayOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalMarginTradeRepayOrders(spotMarginTradeRepayOrdersRequest.getStartTime(), spotMarginTradeRepayOrdersRequest.getEndTime(), spotMarginTradeRepayOrdersRequest.getCoin(), spotMarginTradeRepayOrdersRequest.getLimit()));
    }
}

