/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.websocket.impl;

import com.bybit.api.client.constant.Helper;
import com.bybit.api.client.security.HmacSHA256Signer;
import com.bybit.api.client.websocket.callback.WebSocketMessageCallback;
import com.bybit.api.client.websocket.httpclient.WebSocketStreamHttpClientSingleton;
import com.bybit.api.client.websocket.httpclient.WebsocketStreamClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketStreamClientImpl
implements WebsocketStreamClient {
    private static final String THREAD_PING = "thread-ping";
    private static final String THREAD_PRIVATE_AUTH = "thread-private-auth";
    private static final String PING_DATA = "{\"op\":\"ping\"}";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketStreamClientImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private WebSocketMessageCallback webSocketMessageCallback;
    private final WebSocketStreamHttpClientSingleton webSocketHttpClientSingleton;
    private WebSocket webSocket;
    private boolean isAuthenticated = false;
    private final List<Map<String, Object>> messageQueue = new ArrayList<Map<String, Object>>();
    private final String apikey;
    private final String secret;
    private final String baseUrl;
    private final Boolean debugMode;
    private final String logOption;
    private final Integer pingInterval;
    private final String maxAliveTime;
    private List<String> argNames;
    private Map<String, Object> params;
    private String path;

    public WebsocketStreamClientImpl(String apikey, String secret, String baseUrl, Integer pingInterval, String maxAliveTime, Boolean debugMode, String logOption, WebSocketMessageCallback webSocketMessageCallback) {
        this.webSocketMessageCallback = webSocketMessageCallback;
        this.apikey = apikey;
        this.secret = secret;
        this.baseUrl = baseUrl;
        this.pingInterval = pingInterval;
        this.debugMode = debugMode;
        this.logOption = logOption;
        this.maxAliveTime = maxAliveTime;
        this.webSocketHttpClientSingleton = WebSocketStreamHttpClientSingleton.createInstance(this.debugMode, this.logOption);
    }

    private void setupChannelStream(List<String> argNames, String path) {
        this.argNames = new ArrayList<String>(argNames);
        this.path = path;
    }

    private void setupChannelStream(Map<String, Object> params, String path) {
        this.params = new HashMap<String, Object>(params);
        this.path = path;
    }

    private void sendJsonMessage(WebSocket ws, Object messageObject, String messageType) {
        try {
            String json = objectMapper.writeValueAsString(messageObject);
            ws.send(json);
            LOGGER.info("Sent {}: {}", (Object)messageType, (Object)json);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error serializing {} message: ", (Object)messageType, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSubscribeMessage(WebSocket ws, Map<String, Object> params) {
        if (!this.isAuthenticated) {
            LOGGER.info("Queueing message until authentication is complete.");
            List<Map<String, Object>> list = this.messageQueue;
            synchronized (list) {
                this.messageQueue.add(params);
            }
            return;
        }
        String messageType = "Trade";
        Map<String, Object> subscribeMsg = this.createApiMessage(params);
        this.sendJsonMessage(ws, subscribeMsg, messageType);
    }

    @Override
    public void sendSubscribeMessage(WebSocket ws, List<String> args) {
        String messageType = "Subscribe";
        Map<String, Object> subscribeMsg = this.createSubscribeMessage(args);
        this.sendJsonMessage(ws, subscribeMsg, messageType);
    }

    @NotNull
    private Map<String, Object> createSubscribeMessage(List<String> args) {
        LinkedHashMap<String, Object> wsPostMsg = new LinkedHashMap<String, Object>();
        wsPostMsg.put("req_id", Helper.generateTransferID());
        wsPostMsg.put("op", "subscribe");
        wsPostMsg.put("args", args);
        return wsPostMsg;
    }

    @NotNull
    private Map<String, Object> createApiMessage(Map<String, Object> params) {
        LinkedHashMap<String, Object> wsPostMsg = new LinkedHashMap<String, Object>();
        wsPostMsg.put("reqId", params.getOrDefault("reqId", Helper.generateTransferID()));
        wsPostMsg.put("header", this.constructWsAPIHeaders(params));
        wsPostMsg.put("op", "order.create");
        wsPostMsg.put("args", this.constructWsAPIArgs(params));
        return wsPostMsg;
    }

    private List<Map<String, Object>> constructWsAPIArgs(Map<String, Object> originalParams) {
        HashMap<String, Object> params = new HashMap<String, Object>(originalParams);
        params.remove("X-BAPI-TIMESTAMP");
        params.remove("reqId");
        params.remove("X-BAPI-RECV-WINDOW");
        params.remove("Referer");
        return Collections.singletonList(params);
    }

    private Map<String, String> constructWsAPIHeaders(Map<String, Object> params) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("X-BAPI-TIMESTAMP", String.valueOf(Helper.generateTimestamp()));
        headerMap.put("X-BAPI-RECV-WINDOW", params.getOrDefault("X-BAPI-RECV-WINDOW", 5000L).toString());
        if (params.containsKey("Referer")) {
            headerMap.put("Referer", params.get("Referer").toString());
        }
        return headerMap;
    }

    private boolean requiresAuthentication(String path) {
        return "/v5/trade".equals(path) || "/v5/private".equals(path);
    }

    @NotNull
    private Thread createPingThread() {
        return new Thread(() -> {
            try {
                while (this.webSocket != null) {
                    this.webSocket.send(PING_DATA);
                    LOGGER.info(PING_DATA);
                    TimeUnit.SECONDS.sleep(this.pingInterval.intValue());
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Ping thread was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
    }

    @NotNull
    private Map<String, Object> createAuthMessage() {
        long expires = Instant.now().toEpochMilli() + 10000L;
        String val = "GET/realtime" + expires;
        String signature = HmacSHA256Signer.getSignature(val, this.secret);
        List<String> args = List.of(this.apikey, Long.valueOf(expires), signature);
        return Map.of("req_id", Helper.generateTransferID(), "op", "auth", "args", args);
    }

    private void sendAuthMessage(WebSocket ws) {
        Map<String, Object> authMessage = this.createAuthMessage();
        this.sendJsonMessage(ws, authMessage, "Auth");
    }

    @NotNull
    private Thread createAuthThread(WebSocket ws, Runnable afterAuth) {
        return new Thread(() -> {
            try {
                this.sendAuthMessage(ws);
                if (afterAuth != null) {
                    afterAuth.run();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during authentication: ", (Throwable)e);
            }
        });
    }

    @NotNull
    private String getWssUrl() {
        String wssUrl;
        Pattern pattern = Pattern.compile("(\\d+)([sm])");
        Matcher matcher = pattern.matcher(this.maxAliveTime);
        if (matcher.matches()) {
            int timeValue = Integer.parseInt(matcher.group(1));
            String timeUnit = matcher.group(2);
            boolean isTimeValid = this.isTimeValid(timeUnit, timeValue);
            wssUrl = isTimeValid && this.requiresAuthentication(this.path) ? this.baseUrl + this.path + "?max_alive_time=" + this.maxAliveTime : this.baseUrl + this.path;
        } else {
            wssUrl = this.baseUrl + this.path;
        }
        return wssUrl;
    }

    private boolean isTimeValid(String timeUnit, int timeValue) {
        int minValue = "s".equals(timeUnit) ? 30 : 1;
        int maxValue = "s".equals(timeUnit) ? 600 : 10;
        return timeValue >= minValue && timeValue <= maxValue;
    }

    @NotNull
    private WebSocketListener createWebSocketListener() {
        return new WebSocketListener(){

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                WebsocketStreamClientImpl.this.onClose(webSocket, code, reason);
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                WebsocketStreamClientImpl.this.onError(t);
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                try {
                    WebsocketStreamClientImpl.this.onMessage(text);
                }
                catch (Exception e) {
                    WebsocketStreamClientImpl.this.onError(e);
                }
            }

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                WebsocketStreamClientImpl.this.onOpen(webSocket);
            }
        };
    }

    @Override
    public void setMessageHandler(WebSocketMessageCallback webSocketMessageCallback) {
        this.webSocketMessageCallback = webSocketMessageCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushMessageQueue() {
        List<Map<String, Object>> list = this.messageQueue;
        synchronized (list) {
            for (Map<String, Object> params : this.messageQueue) {
                this.sendSubscribeMessage(this.webSocket, params);
            }
            this.messageQueue.clear();
        }
    }

    @Override
    public void onMessage(String msg) throws JsonProcessingException {
        if (this.requiresAuthentication(this.path) && msg.contains("\"op\":\"auth\"")) {
            this.isAuthenticated = msg.contains("\"retCode\":0");
            if (this.isAuthenticated) {
                LOGGER.info("Authentication successful.");
                this.flushMessageQueue();
            } else {
                LOGGER.error("Authentication failed.");
            }
        }
        if (this.webSocketMessageCallback != null) {
            this.webSocketMessageCallback.onMessage(msg);
        } else {
            LOGGER.info(msg);
        }
    }

    @Override
    public void onError(Throwable t) {
        LOGGER.error(t.getMessage());
    }

    @Override
    public void onClose(WebSocket ws, int code, String reason) {
        LOGGER.info("WebSocket closed. Code: {}, Reason: {}", (Object)code, (Object)reason);
        ws.close(code, reason);
        this.webSocket = null;
    }

    @Override
    public void onOpen(WebSocket ws) {
        if (this.requiresAuthentication(this.path)) {
            Thread authThread = this.createAuthThread(ws, () -> {
                if (this.path.equals("/v5/trade")) {
                    this.sendSubscribeMessage(ws, this.params);
                } else {
                    this.sendSubscribeMessage(ws, this.argNames);
                }
            });
            authThread.start();
        } else {
            this.sendSubscribeMessage(ws, this.argNames);
        }
    }

    @Override
    public WebSocket connect() {
        String wssUrl = this.getWssUrl();
        LOGGER.info(wssUrl);
        this.webSocket = this.webSocketHttpClientSingleton.createWebSocket(wssUrl, this.createWebSocketListener());
        Thread pingThread = this.createPingThread();
        pingThread.setName(THREAD_PING);
        pingThread.start();
        return this.webSocket;
    }

    @Override
    public WebSocket getPublicChannelStream(List<String> argNames, String path) {
        this.setupChannelStream(argNames, path);
        return this.connect();
    }

    @Override
    public WebSocket getPrivateChannelStream(List<String> argNames, String path) {
        this.setupChannelStream(argNames, path);
        return this.connect();
    }

    @Override
    public WebSocket getTradeChannelStream(Map<String, Object> params, String path) {
        this.setupChannelStream(params, path);
        return this.connect();
    }

    public WebSocketMessageCallback getWebSocketMessageCallback() {
        return this.webSocketMessageCallback;
    }

    public WebSocketStreamHttpClientSingleton getWebSocketHttpClientSingleton() {
        return this.webSocketHttpClientSingleton;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public List<Map<String, Object>> getMessageQueue() {
        return this.messageQueue;
    }

    public String getApikey() {
        return this.apikey;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean getDebugMode() {
        return this.debugMode;
    }

    public String getLogOption() {
        return this.logOption;
    }

    public Integer getPingInterval() {
        return this.pingInterval;
    }

    public String getMaxAliveTime() {
        return this.maxAliveTime;
    }

    public List<String> getArgNames() {
        return this.argNames;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getPath() {
        return this.path;
    }
}

