/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.institution.LendingDataRequest;
import com.bybit.api.client.domain.institution.insLending.UpdateInstitutionLoadUidRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncLendingRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncLendingRestClientImpl
implements BybitApiAsyncLendingRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncLendingRestClientImpl(String apiKey, String apiSecret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, apiSecret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public void getInsProductInfo(LendingDataRequest lendingDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsProductInfo(lendingDataRequest.getProductId()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsMarginCoinInfo(LendingDataRequest lendingDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsMarginCoinInfo(lendingDataRequest.getProductId()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsLoanOrders(LendingDataRequest institutionLoanOrdersRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsLoanOrders(institutionLoanOrdersRequest.getOrderId(), institutionLoanOrdersRequest.getStartTime(), institutionLoanOrdersRequest.getEndTime(), institutionLoanOrdersRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsRepayOrders(LendingDataRequest institutionRepayOrdersRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsRepayOrders(institutionRepayOrdersRequest.getStartTime(), institutionRepayOrdersRequest.getEndTime(), institutionRepayOrdersRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsLoanToValue(BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsLoanToValue().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void updateInstitutionLoanUid(LendingDataRequest lendingDataRequest, BybitApiCallback<Object> callback) {
        UpdateInstitutionLoadUidRequest updateInsUidRequest = this.converter.convertToUpdateInsUidRequest(lendingDataRequest);
        this.bybitApiService.updateInstitutionLoanUid(updateInsUidRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

