/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.position.request.BatchMovePositionRequest;
import com.bybit.api.client.domain.position.request.ConfirmNewRiskLimitRequest;
import com.bybit.api.client.domain.position.request.ModifyMarginRequest;
import com.bybit.api.client.domain.position.request.PositionDataRequest;
import com.bybit.api.client.domain.position.request.SetAutoAddMarginRequest;
import com.bybit.api.client.domain.position.request.SetLeverageRequest;
import com.bybit.api.client.domain.position.request.SetRiskLimitRequest;
import com.bybit.api.client.domain.position.request.SetTpSlModeRequest;
import com.bybit.api.client.domain.position.request.SwitchMarginRequest;
import com.bybit.api.client.domain.position.request.SwitchPositionModeRequest;
import com.bybit.api.client.domain.position.request.TradingStopRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncPositionRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncPositionRestClientImpl
implements BybitApiAsyncPositionRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncPositionRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public void getPositionInfo(PositionDataRequest positionListRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPositionInfo(positionListRequest.getCategory().getCategoryTypeId(), positionListRequest.getSymbol(), positionListRequest.getBaseCoin(), positionListRequest.getSettleCoin(), positionListRequest.getLimit(), positionListRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setPositionLeverage(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetLeverageRequest setLeverageRequest = this.converter.mapToSetLeverageRequest(positionDataRequest);
        this.bybitApiService.setPositionLeverage(setLeverageRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void swithMarginRequest(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SwitchMarginRequest switchMarginRequest = this.converter.mapToSwitchMarginRequest(positionDataRequest);
        this.bybitApiService.swithMarginRequest(switchMarginRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void switchPositionMode(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SwitchPositionModeRequest switchPositionModeRequest = this.converter.mapToSwitchPositionModeRequest(positionDataRequest);
        this.bybitApiService.switchPositionMode(switchPositionModeRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void setTpslMode(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetTpSlModeRequest setTpSlModeRequest = this.converter.mapToSetTpSlModeRequest(positionDataRequest);
        this.bybitApiService.setTpslMode(setTpSlModeRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void setRiskLimit(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetRiskLimitRequest setRiskLimitRequest = this.converter.mapToSetRiskLimitRequest(positionDataRequest);
        this.bybitApiService.setRiskLimit(setRiskLimitRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setTradingStop(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        TradingStopRequest tradingStopRequest = this.converter.mapToTradingStopRequest(positionDataRequest);
        this.bybitApiService.setTradingStop(tradingStopRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAutoAddMargin(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetAutoAddMarginRequest setAutoAddMarginRequest = this.converter.mapToSetAutoAddMarginRequest(positionDataRequest);
        this.bybitApiService.setAutoAddMargin(setAutoAddMarginRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifyPositionMargin(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        ModifyMarginRequest modifyMarginRequest = this.converter.mapToModifyMarginRequest(positionDataRequest);
        this.bybitApiService.modifyPositionMargin(modifyMarginRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getClosePnlList(PositionDataRequest closePnlHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getClosePnlList(closePnlHistoryRequest.getCategory().getCategoryTypeId(), closePnlHistoryRequest.getSymbol(), closePnlHistoryRequest.getStartTime(), closePnlHistoryRequest.getEndTime(), closePnlHistoryRequest.getLimit(), closePnlHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMovePositionHistory(PositionDataRequest movePositionHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMovePositionHistory(movePositionHistoryRequest.getCategory().getCategoryTypeId(), movePositionHistoryRequest.getSymbol(), movePositionHistoryRequest.getStartTime(), movePositionHistoryRequest.getEndTime(), movePositionHistoryRequest.getStatus() == null ? null : movePositionHistoryRequest.getStatus().getMovePositionStatus(), movePositionHistoryRequest.getBlockTradeId(), movePositionHistoryRequest.getLimit(), movePositionHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void batchMovePositions(BatchMovePositionRequest batchMovePositionRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.batchMovePositions(batchMovePositionRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void confirmPositionRiskLimit(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        ConfirmNewRiskLimitRequest confirmNewRiskLimitRequest = this.converter.mapToConfirmNewRiskLimitRequest(positionDataRequest);
        this.bybitApiService.confirmPositionRiskLimit(confirmNewRiskLimitRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getClosedOptionsPositions(PositionDataRequest closedOptionsPositionsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getClosedOptionsPositions(closedOptionsPositionsRequest.getCategory().getCategoryTypeId(), closedOptionsPositionsRequest.getSymbol(), closedOptionsPositionsRequest.getStartTime(), closedOptionsPositionsRequest.getEndTime(), closedOptionsPositionsRequest.getLimit(), closedOptionsPositionsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

