/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.rfq.request.RfqDataRequest;
import com.bybit.api.client.domain.rfq.request.RfqLeg;
import com.bybit.api.client.domain.rfq.request.RfqQuoteRequest;
import com.bybit.api.client.domain.rfq.request.RfqRequest;
import com.bybit.api.client.restApi.BybitApiRfqRestClient;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BybitApiRfqRestClientImpl
implements BybitApiRfqRestClient {
    private final BybitApiService bybitApiService;

    public BybitApiRfqRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption, String referer) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, referer);
    }

    @Override
    public Object createRfq(RfqRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getLegs() != null) {
            params.put("legs", this.convertLegsToMap(request.getLegs()));
        }
        if (request.getCounterparties() != null) {
            params.put("counterparties", request.getCounterparties());
        }
        if (request.getRfqLinkId() != null) {
            params.put("rfqLinkId", request.getRfqLinkId());
        }
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createRfq(params));
    }

    @Override
    public Object createRfq(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createRfq(request));
    }

    @Override
    public Object getRfqConfig() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getRfqConfig());
    }

    @Override
    public Object cancelRfq(RfqRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getRfqId() != null) {
            params.put("rfqId", request.getRfqId());
        }
        if (request.getRfqLinkId() != null) {
            params.put("rfqLinkId", request.getRfqLinkId());
        }
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelRfq(params));
    }

    @Override
    public Object cancelRfq(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelRfq(request));
    }

    @Override
    public Object cancelAllRfq(RfqRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getBaseCoin() != null) {
            params.put("baseCoin", request.getBaseCoin());
        }
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAllRfq(params));
    }

    @Override
    public Object cancelAllRfq(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAllRfq(request));
    }

    @Override
    public Object createRfqQuote(RfqQuoteRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rfqId", request.getRfqId());
        if (request.getLegs() != null) {
            params.put("legs", this.convertLegsToMap(request.getLegs()));
        }
        if (request.getQuoteLinkId() != null) {
            params.put("quoteLinkId", request.getQuoteLinkId());
        }
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createRfqQuote(params));
    }

    @Override
    public Object createRfqQuote(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createRfqQuote(request));
    }

    @Override
    public Object executeRfqQuote(RfqQuoteRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("rfqId", request.getRfqId());
        params.put("quoteId", request.getQuoteId());
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.executeRfqQuote(params));
    }

    @Override
    public Object executeRfqQuote(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.executeRfqQuote(request));
    }

    @Override
    public Object cancelRfqQuote(RfqQuoteRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getQuoteId() != null) {
            params.put("quoteId", request.getQuoteId());
        }
        if (request.getQuoteLinkId() != null) {
            params.put("quoteLinkId", request.getQuoteLinkId());
        }
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelRfqQuote(params));
    }

    @Override
    public Object cancelRfqQuote(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelRfqQuote(request));
    }

    @Override
    public Object cancelAllRfqQuotes(RfqQuoteRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getBaseCoin() != null) {
            params.put("baseCoin", request.getBaseCoin());
        }
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAllRfqQuotes(params));
    }

    @Override
    public Object cancelAllRfqQuotes(Map<String, Object> request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAllRfqQuotes(request));
    }

    @Override
    public Object getRfqRealtime(RfqDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getRfqRealtime(request.getRfqId(), request.getRfqLinkId(), request.getBaseCoin(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getRfqHistory(RfqDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getRfqHistory(request.getRfqId(), request.getRfqLinkId(), request.getBaseCoin(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getQuotesRealtime(RfqDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getQuotesRealtime(request.getQuoteId(), request.getQuoteLinkId(), request.getBaseCoin(), request.getRfqId(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getQuotesHistory(RfqDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getQuotesHistory(request.getQuoteId(), request.getQuoteLinkId(), request.getBaseCoin(), request.getRfqId(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getRfqTradeHistory(RfqDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getRfqTradeHistory(request.getBaseCoin(), request.getRfqId(), request.getQuoteId(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getRfqPublicTrades(RfqDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getRfqPublicTrades(request.getBaseCoin(), request.getCategory(), request.getLimit(), request.getCursor()));
    }

    private List<Map<String, Object>> convertLegsToMap(List<RfqLeg> legs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (RfqLeg leg : legs) {
            HashMap<String, String> legMap = new HashMap<String, String>();
            legMap.put("symbol", leg.getSymbol());
            if (leg.getSide() != null) {
                legMap.put("side", leg.getSide().getTransactionSide());
            }
            legMap.put("qty", leg.getQty());
            if (leg.getPrice() != null) {
                legMap.put("price", leg.getPrice());
            }
            result.add(legMap);
        }
        return result;
    }
}

