package io.github.kaposke.http;

import io.github.kaposke.exceptions.ApiException;
import java.util.List;

public interface DocClient {
  io.github.kaposke.models.DocResponse getApprovedByOrgSlugAndApiSlug(
    String orgSlug,
    String apiSlug,
    String apiVersion
  ) throws ApiException;
  java.util.List<io.github.kaposke.models.DocResponse> getAllApprovedByOrgSlugAndApiSlug(
    String orgSlug,
    String apiSlug,
    String apiVersion
  ) throws ApiException;
  java.util.List<io.github.kaposke.models.DocResponse> findDocs(
    float offset,
    float limit,
    float artifactId
  ) throws ApiException;
  io.github.kaposke.models.DocCreatedResponse create(
    io.github.kaposke.models.CreateDocRequest input
  ) throws ApiException;
  io.github.kaposke.models.DocResponse approve(String previewSlug) throws ApiException;
  io.github.kaposke.models.DocResponse getById(float id) throws ApiException;
  io.github.kaposke.models.DocResponse update(
    io.github.kaposke.models.UpdateDocRequest input,
    float id
  ) throws ApiException;
  io.github.kaposke.models.DocResponse remove(float id) throws ApiException;
}
