package io.github.kaposke.services;

import static io.github.kaposke.http.ParameterConverter.toQueryParameterValue;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.*;
import io.github.kaposke.models.BaseModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OrgMemberService extends BaseService implements OrgMemberClient {

  public OrgMemberService(OkHttpClient httpClient) {
    super(httpClient);
  }

  public java.util.List<io.github.kaposke.models.OrgMemberResponse> getByOrgId(float orgId)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(orgId))
      .addPathSegment("members")
      .build()
      .toString();
    Request request = new Request.Builder().url(url).get().build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<java.util.List<io.github.kaposke.models.OrgMemberResponse>>() {}
    );
  }

  public io.github.kaposke.models.OrgMemberResponse createMember(
    io.github.kaposke.models.CreateOrgMemberRequest input,
    float orgId
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(orgId))
      .addPathSegment("members")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).post(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.OrgMemberResponse>() {}
    );
  }

  public io.github.kaposke.models.OrgMemberResponse updateMember(
    io.github.kaposke.models.UpdateOrgMemberRequest input,
    float memberId,
    float orgId
  ) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(orgId))
      .addPathSegment("members")
      .addPathSegment(String.valueOf(memberId))
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(input),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).patch(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.OrgMemberResponse>() {}
    );
  }

  public String removeMember(float memberId, float orgId) throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(orgId))
      .addPathSegment("members")
      .addPathSegment(String.valueOf(memberId))
      .build()
      .toString();
    Request request = new Request.Builder().url(url).delete().build();
    Response response = this.execute(request);

    try {
      return response.body().string();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  public io.github.kaposke.models.UpdateManyOrgMembersResponse enableAllMembers(float orgId)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(orgId))
      .addPathSegment("enable")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(new BaseModel() {}),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).patch(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.UpdateManyOrgMembersResponse>() {}
    );
  }

  public io.github.kaposke.models.UpdateManyOrgMembersResponse disableAllMembers(float orgId)
    throws ApiException {
    String url = HttpUrl
      .parse(Configuration.SERVER_URL)
      .newBuilder()
      .addPathSegment("orgs")
      .addPathSegment(String.valueOf(orgId))
      .addPathSegment("disable")
      .build()
      .toString();
    RequestBody requestBody = RequestBody.create(
      ModelConverter.modelToJson(new BaseModel() {}),
      okhttp3.MediaType.parse("application/json; charset=utf-8")
    );
    Request request = new Request.Builder().url(url).patch(requestBody).build();
    Response response = this.execute(request);

    return ModelConverter.convert(
      response,
      new com.fasterxml.jackson.core.type.TypeReference<io.github.kaposke.models.UpdateManyOrgMembersResponse>() {}
    );
  }
}
