# LLTestJavaSDK Services
A list of all services and services methods.
- Services
    - [BuildService](#buildservice)
    - [ApiService](#apiservice)
    - [OrgService](#orgservice)
    - [ArtifactService](#artifactservice)
    - [SdkService](#sdkservice)
    - [DocService](#docservice)
    - [OrgMemberService](#orgmemberservice)
    - [AuthService](#authservice)
    - [UserService](#userservice)
    - [TokenService](#tokenservice)
    - [HealthCheckService](#healthcheckservice)
    - [EventService](#eventservice)
- [All Methods](#all-methods)

## BuildService

| Method    | Description|
| :-------- | :----------| 
| [buildSdk](#buildsdk) |  |
| [buildDoc](#builddoc) |  |
| [getBuilds](#getbuilds) |  |
| [getById](#getbyid) |  |

## ApiService

| Method    | Description|
| :-------- | :----------| 
| [create](#create) |  |
| [getApis](#getapis) |  |
| [getById](#getbyid) |  |
| [update](#update) |  |
| [remove](#remove) |  |
| [getApiMembers](#getapimembers) |  |
| [getApiSdks](#getapisdks) |  |
| [getApiDocs](#getapidocs) |  |
| [getApiBuilds](#getapibuilds) |  |
| [getApiByOrgSlugAndApiSlug](#getapibyorgslugandapislug) |  |

## OrgService

| Method    | Description|
| :-------- | :----------| 
| [create](#create) |  |
| [getByCurrentUser](#getbycurrentuser) |  |
| [getById](#getbyid) |  |
| [update](#update) |  |
| [remove](#remove) |  |
| [getApis](#getapis) |  |
| [getPayments](#getpayments) |  |
| [getArtifacts](#getartifacts) |  |
| [getDocs](#getdocs) |  |

## ArtifactService

| Method    | Description|
| :-------- | :----------| 
| [create](#create) |  |
| [getArtifacts](#getartifacts) |  |
| [getById](#getbyid) |  |
| [remove](#remove) |  |

## SdkService

| Method    | Description|
| :-------- | :----------| 
| [create](#create) |  |
| [findSdks](#findsdks) |  |
| [getById](#getbyid) |  |
| [remove](#remove) |  |

## DocService

| Method    | Description|
| :-------- | :----------| 
| [getApprovedByOrgSlugAndApiSlug](#getapprovedbyorgslugandapislug) |  |
| [getAllApprovedByOrgSlugAndApiSlug](#getallapprovedbyorgslugandapislug) |  |
| [create](#create) |  |
| [findDocs](#finddocs) |  |
| [approve](#approve) |  |
| [getById](#getbyid) |  |
| [remove](#remove) |  |
| [update](#update) |  |

## OrgMemberService

| Method    | Description|
| :-------- | :----------| 
| [createMember](#createmember) |  |
| [getByOrgId](#getbyorgid) |  |
| [updateMember](#updatemember) |  |
| [removeMember](#removemember) |  |
| [enableAllMembers](#enableallmembers) |  |
| [disableAllMembers](#disableallmembers) |  |

## AuthService

| Method    | Description|
| :-------- | :----------| 
| [signup](#signup) |  |
| [login](#login) |  |
| [logout](#logout) |  |
| [refreshToken](#refreshtoken) |  |
| [resetPassword](#resetpassword) |  |
| [oneTimeLogin](#onetimelogin) |  |
| [changePassword](#changepassword) |  |
| [verifyEmail](#verifyemail) |  |

## UserService

| Method    | Description|
| :-------- | :----------| 
| [getCurrentUser](#getcurrentuser) |  |
| [create](#create) |  |
| [getUserApis](#getuserapis) |  |
| [getById](#getbyid) |  |
| [update](#update) |  |
| [remove](#remove) |  |

## TokenService

| Method    | Description|
| :-------- | :----------| 
| [create](#create) |  |
| [findByUserId](#findbyuserid) |  |
| [getById](#getbyid) |  |
| [remove](#remove) |  |

## HealthCheckService

| Method    | Description|
| :-------- | :----------| 
| [HealthCheckController_check](#healthcheckcontrollercheck) |  |

## EventService

| Method    | Description|
| :-------- | :----------| 
| [track](#track) |  |


## All Methods

### **buildSdk**

- HTTP Method: POST
- Endpoint: /builds/sdk


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[BuildResponse](../models/README.MD#buildresponse) 

**Example Usage Code Snippet**

```

```

### **buildDoc**

- HTTP Method: POST
- Endpoint: /builds/doc


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[BuildResponse](../models/README.MD#buildresponse) 

**Example Usage Code Snippet**

```

```

### **getBuilds**

- HTTP Method: GET
- Endpoint: /builds


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| apiId | float | Required |  |

**Return Type**

[BuildGetBuilds200Response](../models/README.MD#buildgetbuilds200response) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /builds/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[BuildResponse](../models/README.MD#buildresponse) 

**Example Usage Code Snippet**

```

```


### **create**

- HTTP Method: POST
- Endpoint: /apis


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[ApiResponse](../models/README.MD#apiresponse) 

**Example Usage Code Snippet**

```

```

### **getApis**

- HTTP Method: GET
- Endpoint: /apis


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgId | float | Required |  |

**Return Type**

[ApiGetApis200Response](../models/README.MD#apigetapis200response) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /apis/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[ApiResponse](../models/README.MD#apiresponse) 

**Example Usage Code Snippet**

```

```

### **update**

- HTTP Method: PATCH
- Endpoint: /apis/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |
| input | Object | Required | Request body. |

**Return Type**

[ApiResponse](../models/README.MD#apiresponse) 

**Example Usage Code Snippet**

```

```

### **remove**

- HTTP Method: DELETE
- Endpoint: /apis/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```

### **getApiMembers**

- HTTP Method: GET
- Endpoint: /apis/{id}/members


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[ApiGetApiMembers200Response](../models/README.MD#apigetapimembers200response) 

**Example Usage Code Snippet**

```

```

### **getApiSdks**

- HTTP Method: GET
- Endpoint: /apis/{id}/sdks


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[ApiGetApiSdks200Response](../models/README.MD#apigetapisdks200response) 

**Example Usage Code Snippet**

```

```

### **getApiDocs**

- HTTP Method: GET
- Endpoint: /apis/{id}/docs


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[ApiGetApiDocs200Response](../models/README.MD#apigetapidocs200response) 

**Example Usage Code Snippet**

```

```

### **getApiBuilds**

- HTTP Method: GET
- Endpoint: /apis/{id}/builds


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[ApiGetApiBuilds200Response](../models/README.MD#apigetapibuilds200response) 

**Example Usage Code Snippet**

```

```

### **getApiByOrgSlugAndApiSlug**

- HTTP Method: GET
- Endpoint: /apis/{orgSlug}/{apiSlug}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgSlug | String | Required |  |
| apiSlug | String | Required |  |

**Return Type**

[ApiGetApiByOrgSlugAndApiSlug200Response](../models/README.MD#apigetapibyorgslugandapislug200response) 

**Example Usage Code Snippet**

```

```


### **create**

- HTTP Method: POST
- Endpoint: /orgs


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[OrgResponse](../models/README.MD#orgresponse) 

**Example Usage Code Snippet**

```

```

### **getByCurrentUser**

- HTTP Method: GET
- Endpoint: /orgs


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 

**Return Type**

[OrgGetByCurrentUser200Response](../models/README.MD#orggetbycurrentuser200response) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /orgs/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[OrgResponse](../models/README.MD#orgresponse) 

**Example Usage Code Snippet**

```

```

### **update**

- HTTP Method: PATCH
- Endpoint: /orgs/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |
| input | Object | Required | Request body. |

**Return Type**

[OrgResponse](../models/README.MD#orgresponse) 

**Example Usage Code Snippet**

```

```

### **remove**

- HTTP Method: DELETE
- Endpoint: /orgs/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```

### **getApis**

- HTTP Method: GET
- Endpoint: /orgs/{id}/apis


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[OrgGetApis200Response](../models/README.MD#orggetapis200response) 

**Example Usage Code Snippet**

```

```

### **getPayments**

- HTTP Method: GET
- Endpoint: /orgs/{id}/payments


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[OrgGetPayments200Response](../models/README.MD#orggetpayments200response) 

**Example Usage Code Snippet**

```

```

### **getArtifacts**

- HTTP Method: GET
- Endpoint: /orgs/{id}/artifacts


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[OrgGetArtifacts200Response](../models/README.MD#orggetartifacts200response) 

**Example Usage Code Snippet**

```

```

### **getDocs**

- HTTP Method: GET
- Endpoint: /orgs/{id}/docs


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[OrgGetDocs200Response](../models/README.MD#orggetdocs200response) 

**Example Usage Code Snippet**

```

```


### **create**

- HTTP Method: POST
- Endpoint: /artifacts


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[ArtifactResponse](../models/README.MD#artifactresponse) 

**Example Usage Code Snippet**

```

```

### **getArtifacts**

- HTTP Method: GET
- Endpoint: /artifacts


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| buildId | float | Required |  |

**Return Type**

[ArtifactGetArtifacts200Response](../models/README.MD#artifactgetartifacts200response) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /artifacts/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[ApiResponse](../models/README.MD#apiresponse) 

**Example Usage Code Snippet**

```

```

### **remove**

- HTTP Method: DELETE
- Endpoint: /artifacts/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```


### **create**

- HTTP Method: POST
- Endpoint: /sdks


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[SdkResponse](../models/README.MD#sdkresponse) 

**Example Usage Code Snippet**

```

```

### **findSdks**

- HTTP Method: GET
- Endpoint: /sdks


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| offset | float | Required |  |
| limit | float | Required |  |
| artifactId | float | Required |  |

**Return Type**

[SdkFindSdks200Response](../models/README.MD#sdkfindsdks200response) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /sdks/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[SdkResponse](../models/README.MD#sdkresponse) 

**Example Usage Code Snippet**

```

```

### **remove**

- HTTP Method: DELETE
- Endpoint: /sdks/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```


### **getApprovedByOrgSlugAndApiSlug**

- HTTP Method: GET
- Endpoint: /docs/approved


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgSlug | String | Required |  |
| apiSlug | String | Optional |  |
| apiVersion | String | Optional |  |

**Return Type**

[DocResponse](../models/README.MD#docresponse) 

**Example Usage Code Snippet**

```

```

### **getAllApprovedByOrgSlugAndApiSlug**

- HTTP Method: GET
- Endpoint: /docs/approved/all


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgSlug | String | Required |  |
| apiSlug | String | Optional |  |
| apiVersion | String | Optional |  |

**Return Type**

[DocGetAllApprovedByOrgSlugAndApiSlug200Response](../models/README.MD#docgetallapprovedbyorgslugandapislug200response) 

**Example Usage Code Snippet**

```

```

### **create**

- HTTP Method: POST
- Endpoint: /docs


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[DocCreatedResponse](../models/README.MD#doccreatedresponse) 

**Example Usage Code Snippet**

```

```

### **findDocs**

- HTTP Method: GET
- Endpoint: /docs


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| offset | float | Required |  |
| limit | float | Required |  |
| artifactId | float | Required |  |

**Return Type**

[DocFindDocs200Response](../models/README.MD#docfinddocs200response) 

**Example Usage Code Snippet**

```

```

### **approve**

- HTTP Method: POST
- Endpoint: /docs/{previewSlug}/approve


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| previewSlug | String | Required |  |

**Return Type**

[DocResponse](../models/README.MD#docresponse) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /docs/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[DocResponse](../models/README.MD#docresponse) 

**Example Usage Code Snippet**

```

```

### **remove**

- HTTP Method: DELETE
- Endpoint: /docs/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[DocResponse](../models/README.MD#docresponse) 

**Example Usage Code Snippet**

```

```

### **update**

- HTTP Method: PUT
- Endpoint: /docs/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |
| input | Object | Required | Request body. |

**Return Type**

[DocResponse](../models/README.MD#docresponse) 

**Example Usage Code Snippet**

```

```


### **createMember**

- HTTP Method: POST
- Endpoint: /orgs/{orgId}/members


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgId | float | Required |  |
| input | Object | Required | Request body. |

**Return Type**

[OrgMemberResponse](../models/README.MD#orgmemberresponse) 

**Example Usage Code Snippet**

```

```

### **getByOrgId**

- HTTP Method: GET
- Endpoint: /orgs/{orgId}/members


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgId | float | Required |  |

**Return Type**

[OrgmemberGetByOrgId200Response](../models/README.MD#orgmembergetbyorgid200response) 

**Example Usage Code Snippet**

```

```

### **updateMember**

- HTTP Method: PATCH
- Endpoint: /orgs/{orgId}/members/{memberId}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| memberId | float | Required |  |
| orgId | float | Required |  |
| input | Object | Required | Request body. |

**Return Type**

[OrgMemberResponse](../models/README.MD#orgmemberresponse) 

**Example Usage Code Snippet**

```

```

### **removeMember**

- HTTP Method: DELETE
- Endpoint: /orgs/{orgId}/members/{memberId}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| memberId | float | Required |  |
| orgId | float | Required |  |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```

### **enableAllMembers**

- HTTP Method: PATCH
- Endpoint: /orgs/{orgId}/enable


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgId | float | Required |  |

**Return Type**

[UpdateManyOrgMembersResponse](../models/README.MD#updatemanyorgmembersresponse) 

**Example Usage Code Snippet**

```

```

### **disableAllMembers**

- HTTP Method: PATCH
- Endpoint: /orgs/{orgId}/disable


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| orgId | float | Required |  |

**Return Type**

[UpdateManyOrgMembersResponse](../models/README.MD#updatemanyorgmembersresponse) 

**Example Usage Code Snippet**

```

```


### **signup**

- HTTP Method: POST
- Endpoint: /auth/signup


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[UserResponse](../models/README.MD#userresponse) 

**Example Usage Code Snippet**

```

```

### **login**

- HTTP Method: POST
- Endpoint: /auth/login


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[AuthTokenResponse](../models/README.MD#authtokenresponse) 

**Example Usage Code Snippet**

```

```

### **logout**

- HTTP Method: POST
- Endpoint: /auth/logout


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```

### **refreshToken**

- HTTP Method: POST
- Endpoint: /auth/refresh-jwt


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[AuthTokenResponse](../models/README.MD#authtokenresponse) 

**Example Usage Code Snippet**

```

```

### **resetPassword**

- HTTP Method: POST
- Endpoint: /auth/reset-password


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```

### **oneTimeLogin**

- HTTP Method: POST
- Endpoint: /auth/one-time-login


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[AuthTokenResponse](../models/README.MD#authtokenresponse) 

**Example Usage Code Snippet**

```

```

### **changePassword**

- HTTP Method: POST
- Endpoint: /auth/change-password


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[AuthTokenResponse](../models/README.MD#authtokenresponse) 

**Example Usage Code Snippet**

```

```

### **verifyEmail**

- HTTP Method: POST
- Endpoint: /auth/verify-email


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```


### **getCurrentUser**

- HTTP Method: GET
- Endpoint: /users/current-user


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 

**Return Type**

[UserResponse](../models/README.MD#userresponse) 

**Example Usage Code Snippet**

```

```

### **create**

- HTTP Method: POST
- Endpoint: /users


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[UserResponse](../models/README.MD#userresponse) 

**Example Usage Code Snippet**

```

```

### **getUserApis**

- HTTP Method: GET
- Endpoint: /users


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 

**Return Type**

[UserGetUserApis200Response](../models/README.MD#usergetuserapis200response) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /users/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[UserResponse](../models/README.MD#userresponse) 

**Example Usage Code Snippet**

```

```

### **update**

- HTTP Method: PATCH
- Endpoint: /users/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |
| input | Object | Required | Request body. |

**Return Type**

[UserResponse](../models/README.MD#userresponse) 

**Example Usage Code Snippet**

```

```

### **remove**

- HTTP Method: DELETE
- Endpoint: /users/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```


### **create**

- HTTP Method: POST
- Endpoint: /auth/tokens


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

[CreateTokenResponse](../models/README.MD#createtokenresponse) 

**Example Usage Code Snippet**

```

```

### **findByUserId**

- HTTP Method: GET
- Endpoint: /auth/tokens


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| userId | float | Required |  |

**Return Type**

[GetTokenResponse](../models/README.MD#gettokenresponse) 

**Example Usage Code Snippet**

```

```

### **getById**

- HTTP Method: GET
- Endpoint: /auth/tokens/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

[GetTokenResponse](../models/README.MD#gettokenresponse) 

**Example Usage Code Snippet**

```

```

### **remove**

- HTTP Method: DELETE
- Endpoint: /auth/tokens/{id}


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| id | float | Required |  |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```


### **HealthCheckController_check**

- HTTP Method: GET
- Endpoint: /health-check


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 

**Return Type**

[HealthCheckResponse](../models/README.MD#healthcheckresponse) 

**Example Usage Code Snippet**

```

```


### **track**

- HTTP Method: POST
- Endpoint: /events


**Parameters**
| Name    | Type| Required | Description |
| :-------- | :----------| :----------| :----------| 
| input | Object | Required | Request body. |

**Return Type**

Returns a dict object.

**Example Usage Code Snippet**

```

```



