/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.models;

import io.github.kaposke.http.ModelConverter;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BaseModel {
    public BaseModel() {
    }

    protected BaseModel(Builder builder) {
    }

    public String toJson() {
        return ModelConverter.modelToJson(this);
    }

    public static abstract class Builder {
        private final ValidationType _validationType;

        protected Builder(ValidationType validationType) {
            this._validationType = validationType;
        }

        protected abstract Set<String> getNonNullInstanceFieldNames();

        protected abstract Set<Set<String>> getRequiredFieldsGroups();

        protected boolean isValidAllOf() {
            return this.getNonNullInstanceFieldNames().containsAll(this.getRequiredFieldsGroups().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        }

        protected boolean isValidAnyOf() {
            return this.getRequiredFieldsGroups().stream().anyMatch(group -> this.getNonNullInstanceFieldNames().containsAll((Collection<?>)group));
        }

        protected boolean isValidOneOf() {
            return this.getRequiredFieldsGroups().contains(this.getNonNullInstanceFieldNames());
        }

        protected String validate() {
            if (this.getRequiredFieldsGroups().isEmpty()) {
                return null;
            }
            switch (this._validationType) {
                case ALL_OF: {
                    return !this.isValidAllOf() ? "Object fails AllOf validation." : null;
                }
                case ANY_OF: {
                    return !this.isValidAnyOf() ? "Object fails AnyOf validation." : null;
                }
                case ONE_OF: {
                    return !this.isValidOneOf() ? "Object fails OneOf validation." : null;
                }
            }
            return !this.isValidOneOf() ? "Object fails required fields validation." : null;
        }

        protected static enum ValidationType {
            ALL_OF,
            ANY_OF,
            ONE_OF,
            NONE;

        }
    }
}

