/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.DocClient;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.ParameterConverter;
import io.github.kaposke.models.BaseModel;
import io.github.kaposke.models.CreateDocRequest;
import io.github.kaposke.models.DocCreatedResponse;
import io.github.kaposke.models.DocResponse;
import io.github.kaposke.models.UpdateDocRequest;
import io.github.kaposke.services.BaseService;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DocService
extends BaseService
implements DocClient {
    public DocService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public DocResponse getApprovedByOrgSlugAndApiSlug(String orgSlug, String apiSlug, String apiVersion) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").addPathSegment("approved").addQueryParameter("orgSlug", ParameterConverter.toQueryParameterValue(orgSlug)).addQueryParameter("apiSlug", ParameterConverter.toQueryParameterValue(apiSlug)).addQueryParameter("apiVersion", ParameterConverter.toQueryParameterValue(apiVersion)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<DocResponse>(){});
    }

    @Override
    public List<DocResponse> getAllApprovedByOrgSlugAndApiSlug(String orgSlug, String apiSlug, String apiVersion) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").addPathSegment("approved").addPathSegment("all").addQueryParameter("orgSlug", ParameterConverter.toQueryParameterValue(orgSlug)).addQueryParameter("apiSlug", ParameterConverter.toQueryParameterValue(apiSlug)).addQueryParameter("apiVersion", ParameterConverter.toQueryParameterValue(apiVersion)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<DocResponse>>(){});
    }

    @Override
    public List<DocResponse> findDocs(float offset, float limit, float artifactId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").addQueryParameter("offset", ParameterConverter.toQueryParameterValue(Float.valueOf(offset))).addQueryParameter("limit", ParameterConverter.toQueryParameterValue(Float.valueOf(limit))).addQueryParameter("artifactId", ParameterConverter.toQueryParameterValue(Float.valueOf(artifactId))).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<List<DocResponse>>(){});
    }

    @Override
    public DocCreatedResponse create(CreateDocRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<DocCreatedResponse>(){});
    }

    @Override
    public DocResponse approve(String previewSlug) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").addPathSegment(String.valueOf(previewSlug)).addPathSegment("approve").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(new BaseModel(){}), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<DocResponse>(){});
    }

    @Override
    public DocResponse getById(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<DocResponse>(){});
    }

    @Override
    public DocResponse update(UpdateDocRequest input, float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").addPathSegment(String.valueOf(id)).build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).put(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<DocResponse>(){});
    }

    @Override
    public DocResponse remove(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("docs").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<DocResponse>(){});
    }
}

