/*
 * Decompiled with CFR 0.152.
 */
package io.github.kaposke.services;

import com.fasterxml.jackson.core.type.TypeReference;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.http.ParameterConverter;
import io.github.kaposke.http.TokenClient;
import io.github.kaposke.models.CreateTokenRequest;
import io.github.kaposke.models.CreateTokenResponse;
import io.github.kaposke.models.GetTokenResponse;
import io.github.kaposke.services.BaseService;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TokenService
extends BaseService
implements TokenClient {
    public TokenService(OkHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public GetTokenResponse findByUserId(float userId) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("tokens").addQueryParameter("userId", ParameterConverter.toQueryParameterValue(Float.valueOf(userId))).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<GetTokenResponse>(){});
    }

    @Override
    public CreateTokenResponse create(CreateTokenRequest input) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("tokens").build().toString();
        RequestBody requestBody = RequestBody.create((String)ModelConverter.modelToJson(input), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(requestBody).build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<CreateTokenResponse>(){});
    }

    @Override
    public GetTokenResponse getById(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("tokens").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.execute(request);
        return ModelConverter.convert(response, new TypeReference<GetTokenResponse>(){});
    }

    @Override
    public String remove(float id) throws ApiException {
        String url = HttpUrl.parse((String)"https://api-dev.liblab.com").newBuilder().addPathSegment("auth").addPathSegment("tokens").addPathSegment(String.valueOf(id)).build().toString();
        Request request = new Request.Builder().url(url).delete().build();
        Response response = this.execute(request);
        try {
            return response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

