package io.github.kaposke;

import io.github.kaposke.http.interceptors.DefaultHeadersInterceptor;
import io.github.kaposke.http.interceptors.RefreshTokenInterceptor;
import io.github.kaposke.http.interceptors.RetryInterceptor;
import io.github.kaposke.services.*;
import java.util.Map;
import okhttp3.OkHttpClient;

public class LLTestJavaSDK {

  public BuildService buildService;
  public ApiService apiService;
  public OrgService orgService;
  public ArtifactService artifactService;
  public SdkService sdkService;
  public DocService docService;
  public OrgMemberService orgmemberService;
  public AuthService authService;
  public UserService userService;
  public TokenService tokenService;
  public HealthCheckService healthcheckService;
  public EventService eventService;

  private final RefreshTokenInterceptor refreshTokenInterceptor = new RefreshTokenInterceptor(
    Configuration.SERVER_URL + "/auth/refresh-jwt",
    "refreshToken",
    "accessToken",
    "refreshToken"
  );

  public LLTestJavaSDK() {
    final OkHttpClient httpClient = new OkHttpClient.Builder()
      .addInterceptor(new DefaultHeadersInterceptor())
      .addInterceptor(new RetryInterceptor())
      .addInterceptor(refreshTokenInterceptor)
      .build();

    this.buildService = new BuildService(httpClient);
    this.apiService = new ApiService(httpClient);
    this.orgService = new OrgService(httpClient);
    this.artifactService = new ArtifactService(httpClient);
    this.sdkService = new SdkService(httpClient);
    this.docService = new DocService(httpClient);
    this.orgmemberService = new OrgMemberService(httpClient);
    this.authService = new AuthService(httpClient);
    this.userService = new UserService(httpClient);
    this.tokenService = new TokenService(httpClient);
    this.healthcheckService = new HealthCheckService(httpClient);
    this.eventService = new EventService(httpClient);
  }

  public LLTestJavaSDK(String refreshToken, String bearerToken) {
    this();
    setRefreshToken(refreshToken);
    setBearerToken(bearerToken);
  }

  public void setRefreshToken(String token) {
    this.refreshTokenInterceptor.setRefreshToken(token);
  }

  public void setBearerToken(String token) {
    this.refreshTokenInterceptor.setBearerToken(token);
  }
}
