package io.github.kaposke.http;

import static io.github.kaposke.http.ModelConverter.modelToJson;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Provides static methods to convert values (object, array, primitive) into url query parameter string representation.
 */
public class ParameterConverter {

  /**
   * Converts any value (object, array, primitive) into a string representation that can be used as url query
   * parameter value.
   *
   * @param value The value (object, array or primitive) to be converted.
   * @return A string representation of the input value in a format that can be used as url query parameter value.
   */
  public static String toQueryParameterValue(final Object value) {
    if (value == null) {
      return "";
    }
    if (
      value instanceof String ||
      value instanceof Number ||
      value instanceof Boolean ||
      value instanceof Enum<?>
    ) {
      return String.valueOf(value);
    }
    if (value instanceof List<?>) {
      List<?> list = (List<?>) value;
      return list
        .stream()
        .map(ParameterConverter::toQueryParameterValue)
        .collect(Collectors.joining(","));
    }

    return modelToJson(value);
  }
}
