package io.github.kaposke.models;

@lombok.Getter
@lombok.EqualsAndHashCode(callSuper = false)
@lombok.ToString
@com.fasterxml.jackson.annotation.JsonInclude(
  com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL
)
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(builder = DocResponse.Builder.class)
public class DocResponse extends io.github.kaposke.models.BaseModel {

  @lombok.Getter
  @lombok.Setter
  @lombok.experimental.Accessors(chain = true)
  @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(
    buildMethodName = "buildWithoutValidation",
    withPrefix = "set"
  )
  public static class Builder extends io.github.kaposke.models.BaseModel.Builder {

    static final java.util.Set<java.util.Set<String>> REQUIRED_FIELDS_GROUPS;

    static {
      java.lang.String[][] requiredFieldsGroups = new java.lang.String[][] {
        new java.lang.String[] {
          "artifactId",
          "createdAt",
          "fileLocation",
          "id",
          "previewSlug",
          "previewUrl",
          "updatedAt",
          "version",
        },
      };

      REQUIRED_FIELDS_GROUPS =
        java.util.Arrays
          .stream(requiredFieldsGroups)
          .map(group -> java.util.Arrays.stream(group).collect(java.util.stream.Collectors.toSet()))
          .collect(java.util.stream.Collectors.toSet());
    }

    @com.fasterxml.jackson.annotation.JsonProperty("approvedDocUrl")
    private java.lang.String approvedDocUrl;

    @com.fasterxml.jackson.annotation.JsonProperty("artifactId")
    private java.lang.Double artifactId;

    @com.fasterxml.jackson.annotation.JsonProperty("createdAt")
    private java.lang.String createdAt;

    @com.fasterxml.jackson.annotation.JsonProperty("fileLocation")
    private java.lang.String fileLocation;

    @com.fasterxml.jackson.annotation.JsonProperty("id")
    private java.lang.Double id;

    @com.fasterxml.jackson.annotation.JsonProperty("previewSlug")
    private java.lang.String previewSlug;

    @com.fasterxml.jackson.annotation.JsonProperty("previewUrl")
    private java.lang.String previewUrl;

    @com.fasterxml.jackson.annotation.JsonProperty("updatedAt")
    private java.lang.String updatedAt;

    @com.fasterxml.jackson.annotation.JsonProperty("version")
    private java.lang.String version;

    public Builder() {
      super(ValidationType.ALL_OF);
    }

    protected Builder(BaseModel.Builder.ValidationType validationType) {
      super(validationType);
    }

    public DocResponse build() {
      String validateMsg = validate();

      if (validateMsg != null) {
        throw new io.github.kaposke.exceptions.ApiException(validateMsg);
      }

      return buildWithoutValidation();
    }

    public DocResponse buildWithoutValidation() {
      return new DocResponse(this);
    }

    @Override
    protected java.util.Set<String> getNonNullInstanceFieldNames() {
      // Introspect the class to get a list of all declared fields.
      return java.util.Arrays
        .stream(this.getClass().getDeclaredFields())
        .filter(field -> {
          try {
            // Filter fields that are non-static and have values that are not null.
            return (
              !java.lang.reflect.Modifier.isStatic(field.getModifiers()) && field.get(this) != null
            );
          } catch (IllegalArgumentException | IllegalAccessException e) {
            // This should never happen...

            throw new io.github.kaposke.exceptions.ApiException(
              "Unexpected exception thrown while accessing instance fields.",
              e
            );
          }
        })
        .map(java.lang.reflect.Field::getName)
        .collect(java.util.stream.Collectors.toSet());
    }

    @Override
    protected java.util.Set<java.util.Set<String>> getRequiredFieldsGroups() {
      return REQUIRED_FIELDS_GROUPS;
    }
  }

  @com.fasterxml.jackson.annotation.JsonProperty("approvedDocUrl")
  private final java.lang.String approvedDocUrl;

  @com.fasterxml.jackson.annotation.JsonProperty("artifactId")
  private final java.lang.Double artifactId;

  @com.fasterxml.jackson.annotation.JsonProperty("createdAt")
  private final java.lang.String createdAt;

  @com.fasterxml.jackson.annotation.JsonProperty("fileLocation")
  private final java.lang.String fileLocation;

  @com.fasterxml.jackson.annotation.JsonProperty("id")
  private final java.lang.Double id;

  @com.fasterxml.jackson.annotation.JsonProperty("previewSlug")
  private final java.lang.String previewSlug;

  @com.fasterxml.jackson.annotation.JsonProperty("previewUrl")
  private final java.lang.String previewUrl;

  @com.fasterxml.jackson.annotation.JsonProperty("updatedAt")
  private final java.lang.String updatedAt;

  @com.fasterxml.jackson.annotation.JsonProperty("version")
  private final java.lang.String version;

  DocResponse(Builder builder) {
    super(builder);
    this.approvedDocUrl = builder.getApprovedDocUrl();
    this.artifactId = builder.getArtifactId();
    this.createdAt = builder.getCreatedAt();
    this.fileLocation = builder.getFileLocation();
    this.id = builder.getId();
    this.previewSlug = builder.getPreviewSlug();
    this.previewUrl = builder.getPreviewUrl();
    this.updatedAt = builder.getUpdatedAt();
    this.version = builder.getVersion();
  }
}
