package io.github.kaposke.services;

import io.github.kaposke.Configuration;
import io.github.kaposke.exceptions.ApiException;
import io.github.kaposke.http.ModelConverter;
import io.github.kaposke.models.*;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class BaseService {

  protected OkHttpClient httpClient;

  public BaseService(OkHttpClient httpClient) {
    this.httpClient = httpClient;
  }

  protected Response execute(Request request) throws ApiException {
    Response response;
    try {
      response = this.httpClient.newCall(request).execute();
    } catch (IOException e) {
      ApiException apiException = new ApiException(e.getMessage());

      throw apiException;
    }
    if (response.isSuccessful()) {
      return response;
    } else {
      ApiException apiException = new ApiException(response.code());

      throw apiException;
    }
  }
}
